/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIConformance;
import org.geoserver.ogcapi.ConformanceInfo;
import org.geoserver.wfs.WFSInfo;

public class FeatureConformance
extends ConformanceInfo<WFSInfo> {
    public static String METADATA_KEY = "ogcapiFeatures";
    public static final APIConformance CORE = new APIConformance("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core", APIConformance.Level.STANDARD);
    public static final APIConformance HTML = CORE.extend("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html");
    public static final APIConformance GEOJSON = CORE.extend("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson");
    public static final APIConformance OAS30 = CORE.extend("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30");
    public static final APIConformance GML321 = new APIConformance("http://schemas.opengis.net/gml/3.2.1/gml.xsd", APIConformance.Level.STANDARD);
    public static final APIConformance GMLSF0 = CORE.extend("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf0");
    public static final APIConformance GMLSF2 = CORE.extend("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf2");
    public static final APIConformance CRS_BY_REFERENCE = CORE.extend("http://www.opengis.net/spec/ogcapi-features-2/1.0/conf/crs");
    public static final APIConformance FEATURES_FILTER = CORE.extend("http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/features-filter");
    public static final APIConformance FILTER = CORE.extend("http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/filter");
    public static final APIConformance QUERYABLES = CORE.extend("http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/queryables");
    public static final APIConformance IDS = new APIConformance("http://www.opengis.net/spec/ogcapi-features-1/1.1/req/ids", APIConformance.Level.DRAFT_STANDARD);
    public static final APIConformance SEARCH = new APIConformance("http://www.opengis.net/spec/ogcapi-features-5/1.0/req/search", APIConformance.Level.DRAFT_STANDARD);
    public static final APIConformance SORTBY = new APIConformance("http://www.opengis.net/spec/ogcapi-records-1/1.0/req/sorting", APIConformance.Level.DRAFT_STANDARD);
    private Boolean core = null;
    private Boolean gml321 = null;
    private Boolean gmlSF0 = null;
    private Boolean gmlSF2 = null;
    private Boolean featuresFilter = null;
    private Boolean crsByReference = null;
    private Boolean filter = null;
    private Boolean search = null;
    private Boolean queryables = null;
    private Boolean ids = null;
    private Boolean sortBy = null;

    public boolean isEnabled(WFSInfo wfsInfo) {
        return this.core(wfsInfo);
    }

    public static FeatureConformance configuration(WFSInfo wfsInfo) {
        if (wfsInfo.getMetadata().containsKey((Object)METADATA_KEY)) {
            return (FeatureConformance)((Object)wfsInfo.getMetadata().get((Object)METADATA_KEY));
        }
        FeatureConformance conf = new FeatureConformance();
        wfsInfo.getMetadata().put(METADATA_KEY, (Serializable)((Object)conf));
        return conf;
    }

    public List<APIConformance> conformances(WFSInfo serviceInfo) {
        ArrayList<APIConformance> conformance = new ArrayList<APIConformance>();
        if (this.isEnabled(serviceInfo)) {
            conformance.add(CORE);
            conformance.add(OAS30);
            conformance.add(HTML);
            conformance.add(GEOJSON);
            if (this.crsByReference(serviceInfo)) {
                conformance.add(CRS_BY_REFERENCE);
            }
            if (this.featuresFilter(serviceInfo)) {
                conformance.add(FEATURES_FILTER);
            }
            if (this.filter(serviceInfo)) {
                conformance.add(FILTER);
            }
            if (this.queryables(serviceInfo)) {
                conformance.add(QUERYABLES);
            }
            if (this.gml321(serviceInfo)) {
                conformance.add(GML321);
            }
            if (this.ids(serviceInfo)) {
                conformance.add(IDS);
            }
            if (this.search(serviceInfo)) {
                conformance.add(SEARCH);
            }
            if (this.sortBy(serviceInfo)) {
                conformance.add(SORTBY);
            }
        }
        return conformance;
    }

    public Boolean isCore() {
        return this.core;
    }

    public void setCore(Boolean enabled) {
        this.core = enabled;
    }

    public boolean core(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.core, CORE);
    }

    public Boolean isGML321() {
        return this.gml321;
    }

    public void setGML321(Boolean enabled) {
        this.gml321 = enabled;
    }

    public boolean gml321(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.gml321, GML321);
    }

    public Boolean isGMLSFO() {
        return this.gmlSF0;
    }

    public void setGMLSF0(Boolean enabled) {
        this.gmlSF0 = enabled;
    }

    public boolean gmlSF0(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.gmlSF0, GMLSF0);
    }

    public Boolean isGMLSF2() {
        return this.gmlSF2;
    }

    public boolean gmlSF2(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.gmlSF2, GMLSF2);
    }

    public void setGMLSF2(Boolean enabled) {
        this.gmlSF2 = enabled;
    }

    public Boolean isCRSByReference() {
        return this.crsByReference;
    }

    public boolean crsByReference(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.crsByReference, CRS_BY_REFERENCE);
    }

    public void setCRSByReference(Boolean enabled) {
        this.crsByReference = enabled;
    }

    public Boolean isFeaturesFilter() {
        return this.featuresFilter;
    }

    public boolean featuresFilter(WFSInfo serviceInfo) {
        return this.filter(serviceInfo) && this.isEnabled((ServiceInfo)serviceInfo, this.featuresFilter, FEATURES_FILTER);
    }

    public void setFeaturesFilter(Boolean enabled) {
        this.featuresFilter = enabled;
    }

    public Boolean isFilter() {
        return this.filter;
    }

    public boolean filter(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.filter, FILTER);
    }

    public void setFilter(Boolean enabled) {
        this.filter = enabled;
    }

    public Boolean isSearch() {
        return this.search;
    }

    public boolean search(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.search, SEARCH);
    }

    public void setSearch(Boolean enabled) {
        this.search = enabled;
    }

    public Boolean isQueryables() {
        return this.queryables;
    }

    public boolean queryables(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.queryables, QUERYABLES);
    }

    public void setQueryables(Boolean enabled) {
        this.queryables = enabled;
    }

    public Boolean isIDs() {
        return this.ids;
    }

    public boolean ids(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.ids, IDS);
    }

    public void setIDs(Boolean enabled) {
        this.ids = enabled;
    }

    public Boolean isSortBy() {
        return this.sortBy;
    }

    public boolean sortBy(WFSInfo serviceInfo) {
        return this.isEnabled((ServiceInfo)serviceInfo, this.sortBy, SORTBY);
    }

    public void setSortBy(Boolean enabled) {
        this.sortBy = enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureConformance");
        sb.append(" ").append(METADATA_KEY);
        sb.append(" { core=").append(this.core);
        sb.append(", crsByReference=").append(this.crsByReference);
        sb.append(", featuresFilter=").append(this.featuresFilter);
        sb.append(", filter=").append(this.filter);
        sb.append(", gmlSF0=").append(this.gmlSF0);
        sb.append(", gmlSF2=").append(this.gmlSF2);
        sb.append(", ids=").append(this.ids);
        sb.append(", queryables=").append(this.queryables);
        sb.append(", search=").append(this.search);
        sb.append(", sortBy=").append(this.sortBy);
        sb.append('}');
        return sb.toString();
    }
}

