/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.cql2.CQLException;

class SpatialOperationBuilder {
    private final BuildResultStack resultStack;
    private final FilterFactory filterFactory;

    public SpatialOperationBuilder(BuildResultStack resultStack, FilterFactory filterFactory) {
        assert (resultStack != null);
        assert (filterFactory != null);
        this.resultStack = resultStack;
        this.filterFactory = filterFactory;
    }

    protected final BuildResultStack getResultStack() {
        return this.resultStack;
    }

    protected final FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    private Expression[] buildParameters() throws CQLException {
        Expression[] params = new Expression[2];
        params[1] = this.resultStack.popExpression();
        params[0] = this.resultStack.popExpression();
        return params;
    }

    protected BinarySpatialOperator buildFilter(Expression expr1, Expression expr2) {
        throw new UnsupportedOperationException("must be implemented");
    }

    protected Contains buildContains() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().contains(params[0], params[1]);
    }

    public Equals buildEquals() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().equal(params[0], params[1]);
    }

    public Disjoint buildDisjoint() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().disjoint(params[0], params[1]);
    }

    public Intersects buildIntersects() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().intersects(params[0], params[1]);
    }

    public Touches buildTouches() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().touches(params[0], params[1]);
    }

    public Crosses buildCrosses() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().crosses(params[0], params[1]);
    }

    public Within buildWithin() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().within(params[0], params[1]);
    }

    public Overlaps buildOverlaps() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().overlaps(params[0], params[1]);
    }

    public Filter buildBBoxWithCRS() throws CQLException {
        String crs = this.getResultStack().popStringValue();
        assert (crs != null);
        return this.buildBBox(crs);
    }

    public Filter buildBBox() throws CQLException {
        return this.buildBBox(null);
    }

    private Filter buildBBox(String crs) throws CQLException {
        double maxY = this.getResultStack().popDoubleValue();
        double maxX = this.getResultStack().popDoubleValue();
        double minY = this.getResultStack().popDoubleValue();
        double minX = this.getResultStack().popDoubleValue();
        Expression expr = this.getResultStack().popExpression();
        FilterFactory ff = this.getFilterFactory();
        if (SpatialOperationBuilder.isWrappingDateline(minX, maxX)) {
            BBOX bbox1 = ff.bbox(expr, minX, minY, 180.0, maxY, crs);
            BBOX bbox2 = ff.bbox(expr, -180.0, minY, maxX, maxY, crs);
            return ff.and((Filter)bbox1, (Filter)bbox2);
        }
        BBOX bbox = ff.bbox(expr, minX, minY, maxX, maxY, crs);
        return bbox;
    }

    static boolean isWrappingDateline(double minLon, double maxLon) {
        return minLon > maxLon && SpatialOperationBuilder.validLongitude(minLon) && SpatialOperationBuilder.validLongitude(maxLon);
    }

    static boolean validLongitude(double x) {
        return x >= -180.0 && x <= 180.0;
    }
}

