/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.api.temporal.Period;
import org.geotools.filter.text.commons.ExpressionToText;

public class CQL2ExpressionToText
extends ExpressionToText {
    public CQL2ExpressionToText() {
        super(false);
    }

    public StringBuilder dateToText(Date date, StringBuilder output) {
        boolean sqlDate = date instanceof java.sql.Date;
        SimpleDateFormat formatter = sqlDate ? new SimpleDateFormat("yyyy-MM-dd") : (date.getTime() % 1000L == 0L ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz"));
        if (!(date instanceof java.sql.Date)) {
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        String text = formatter.format(date);
        text = text.replace("UTC", "Z");
        if (sqlDate) {
            output.append("DATE('").append(text).append("')");
        } else {
            output.append("TIMESTAMP('").append(text).append("')");
        }
        return output;
    }

    protected StringBuilder periodToText(Period period, StringBuilder output) {
        output.append("INTERVAL(");
        output = this.dateToText(period.getBeginning().getPosition().getDate(), output);
        output.append(", ");
        output = this.dateToText(period.getEnding().getPosition().getDate(), output);
        output.append(")");
        return output;
    }
}

