/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.crs.netcdf;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.coverage.io.netcdf.crs.NetCDFCRSAuthorityFactory;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;

public class NetCDFCRSOverridingAuthorityFactory
extends NetCDFCRSAuthorityFactory
implements CRSAuthorityFactory {
    public NetCDFCRSOverridingAuthorityFactory() {
        this(null);
    }

    public NetCDFCRSOverridingAuthorityFactory(Hints userHints) {
        super(userHints, 98);
    }

    protected URL getDefinitionsURL() {
        File proj_file;
        Resource custom_proj;
        GeoServerResourceLoader loader;
        String cust_proj_file = System.getProperty("netcdf.projections.file");
        if (cust_proj_file == null && (loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)) != null && (custom_proj = loader.get("user_projections/netcdf.projections.properties")).getType() == Resource.Type.RESOURCE) {
            cust_proj_file = custom_proj.file().getAbsolutePath();
        }
        if (cust_proj_file != null && (proj_file = new File(cust_proj_file)).exists()) {
            URL url = URLs.fileToUrl((File)proj_file);
            if (url != null) {
                return url;
            }
            LOGGER.log(Level.SEVERE, "Had troubles converting " + cust_proj_file + " to URL");
        }
        cust_proj_file = "override_epsg.netcdf.properties";
        return NetCDFCRSOverridingAuthorityFactory.class.getResource(cust_proj_file);
    }
}

