/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import net.sourceforge.hatbox.wk.AbstractGeometryHandler;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.ParserConstants;
import net.sourceforge.hatbox.wk.WKBArrayInputStream;
import net.sourceforge.hatbox.wk.WKBEnvelope;
import net.sourceforge.hatbox.wk.WKBGeometryType;
import net.sourceforge.hatbox.wk.WKBParseState;
import net.sourceforge.hatbox.wk.WKTParseState;

public class WKParser
implements ParserConstants {
    private WKParser() {
    }

    public static WKBEnvelope readEnvelope(byte[] wkb) throws IOException {
        if (wkb == null) {
            throw new IllegalArgumentException("WKB byte array not provided");
        }
        WKBParseState state = new WKBParseState();
        state.setEnvelope(new WKBEnvelope());
        WKParser.parseWKB(new WKBArrayInputStream(wkb), state);
        return state.getEnvelope();
    }

    public static WKBEnvelope readEnvelope(InputStream wkb) throws IOException {
        if (wkb == null) {
            throw new IllegalArgumentException("WKB InputStream not provided");
        }
        WKBParseState state = new WKBParseState();
        state.setEnvelope(new WKBEnvelope());
        WKParser.parseWKB(wkb, state);
        return state.getEnvelope();
    }

    public static String toWKT(byte[] wkb) throws IOException {
        if (wkb == null) {
            throw new IllegalArgumentException("WKB byte array not provided");
        }
        WKBParseState state = new WKBParseState();
        state.setStringBuilder(new StringBuilder());
        WKParser.parseWKB(new WKBArrayInputStream(wkb), state);
        return state.getStringBuilder().toString();
    }

    public static String toWKT(InputStream wkb) throws IOException {
        if (wkb == null) {
            throw new IllegalArgumentException("WKB InputStream not provided");
        }
        WKBParseState state = new WKBParseState();
        state.setStringBuilder(new StringBuilder());
        WKParser.parseWKB(wkb, state);
        return state.getStringBuilder().toString();
    }

    public static byte[] parseWKT(String wkt) throws IOException, ParseException {
        if (wkt == null) {
            throw new IllegalArgumentException("WKT String not provided");
        }
        return WKParser.parseWKT(new StringReader(wkt));
    }

    public static byte[] parseWKT(Reader wkt) throws IOException, ParseException {
        if (wkt == null) {
            throw new IllegalArgumentException("WKT Reader not provided");
        }
        StreamTokenizer t = new StreamTokenizer(wkt);
        StringBuilder buf = new StringBuilder();
        WKTParseState state = null;
        int token = t.nextToken();
        while (token != -1) {
            switch (token) {
                case -3: {
                    String typeName = t.sval.toUpperCase();
                    buf.append(typeName);
                    WKBGeometryType type = null;
                    try {
                        type = WKBGeometryType.getByName(typeName);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ParseException("Unregognized type name : " + buf + " <===");
                    }
                    if (state == null) {
                        state = new WKTParseState();
                        state.setType(type);
                        state.setBuf(buf);
                        break;
                    }
                    if (state.getState() == 2) {
                        state.setState(25);
                        WKTParseState child = new WKTParseState();
                        child.setType(type);
                        child.setBuf(buf);
                        state.addChild(child);
                        state = child;
                        break;
                    }
                    throw new ParseException("Type name found but not expected: " + buf + " <===");
                }
                case -2: {
                    buf.append(' ');
                    buf.append(t.nval);
                    if (state == null) {
                        throw new ParseException("No type set: " + buf);
                    }
                    state = state.setOrd(t.nval);
                    break;
                }
                case 40: 
                case 41: 
                case 44: {
                    buf.append((char)token);
                    if (state == null) {
                        throw new ParseException("No type set: " + buf);
                    }
                    state = state.getType().getHandler().handleToken(token, state);
                    break;
                }
                default: {
                    throw new ParseException("Unexpected token : " + buf + " <===");
                }
            }
            token = t.nextToken();
        }
        if (state == null) {
            throw new ParseException("No type set: " + buf);
        }
        if (state.getParent() != null) {
            throw new ParseException("Not properly closed: " + buf);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        state.getType().getHandler().writeWKB(os, state);
        os.close();
        return os.toByteArray();
    }

    public static WKBGeometryType parseWKB(InputStream is, WKBParseState state) throws IOException {
        boolean srid;
        state.setEndian(AbstractGeometryHandler.getByte(is));
        int typeEtc = AbstractGeometryHandler.getInt(is, state);
        WKBGeometryType type = WKBGeometryType.getById(typeEtc & 0xFF);
        state.setType(type);
        state.setHasZ((typeEtc & Integer.MIN_VALUE) != 0);
        boolean bl = srid = (typeEtc & 0x20000000) != 0;
        if (srid) {
            AbstractGeometryHandler.getInt(is, state);
        }
        if (state.isBuildingString()) {
            if (state.getParent() == null) {
                state.openType(type.name());
            } else if (state.getParent().getType().isCollection()) {
                state.openType(type.name());
            } else {
                state.openType(null);
            }
            type.getHandler().readWKB(is, state);
            state.closeType();
        } else {
            type.getHandler().readWKB(is, state);
        }
        return type;
    }
}

