/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import net.sourceforge.hatbox.wk.CollectionHandler;
import net.sourceforge.hatbox.wk.GeometryHandler;
import net.sourceforge.hatbox.wk.LinestringHandler;
import net.sourceforge.hatbox.wk.MultiHandler;
import net.sourceforge.hatbox.wk.PointHandler;
import net.sourceforge.hatbox.wk.PolygonHandler;

public enum WKBGeometryType {
    POINT(null, new PointHandler(), false, false),
    LINESTRING(null, new LinestringHandler(), false, false),
    POLYGON(null, new PolygonHandler(), false, false),
    MULTIPOINT(POINT, new MultiHandler(), false, false),
    MULTILINESTRING(LINESTRING, new MultiHandler(), false, false),
    MULTIPOLYGON(POLYGON, new MultiHandler(), false, false),
    GEOMETRYCOLLECTION(null, new CollectionHandler(), true, false),
    BROKEN_MULTIPOINT(null, new LinestringHandler(), false, true);

    private WKBGeometryType componentType;
    private GeometryHandler handler;
    private boolean collection;
    private boolean internal;

    private WKBGeometryType(WKBGeometryType componentType, GeometryHandler handler, boolean collection, boolean internal) {
        this.componentType = componentType;
        this.handler = handler;
        this.collection = collection;
        this.internal = internal;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    public WKBGeometryType getComponentType() {
        return this.componentType;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public GeometryHandler getHandler() {
        return this.handler;
    }

    public static WKBGeometryType getById(int id) {
        if (id > 0 && id < WKBGeometryType.values().length) {
            return WKBGeometryType.values()[id - 1];
        }
        throw new IllegalArgumentException("Not a legal WKBGeometryType id: " + id);
    }

    public static WKBGeometryType getByName(String name) {
        WKBGeometryType type = WKBGeometryType.valueOf(name);
        if (type.isInternal()) {
            throw new IllegalArgumentException("Not a legal WKBGeometryType: " + name);
        }
        return type;
    }
}

