/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.hatbox.wk.AbstractGeometryHandler;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.WKBParseState;
import net.sourceforge.hatbox.wk.WKTParseState;

public class PolygonHandler
extends AbstractGeometryHandler {
    @Override
    public void readWKB(InputStream is, WKBParseState work) throws IOException {
        int rings = PolygonHandler.getInt(is, work);
        for (int i = 0; i < rings; ++i) {
            this.readLinearRing(is, work);
        }
    }

    @Override
    public void writeWKB(OutputStream os, WKTParseState state) throws IOException, ParseException {
        this.writeWKBHeader(os, state);
        this.writeInt(state.getLinestrings().size(), os, state);
        for (List<WKTParseState.Coord> ring : state.getLinestrings()) {
            this.writeInt(ring.size(), os, state);
            for (WKTParseState.Coord c : ring) {
                this.writeCoord(os, c, state);
            }
        }
    }

    @Override
    public WKTParseState handleToken(int token, WKTParseState state) throws ParseException {
        return state.polygonToken(token);
    }
}

