/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.jts;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.RTree;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeSessionDb;
import net.sourceforge.hatbox.jts.AbstractTrigger;
import net.sourceforge.hatbox.wk.WKBEnvelope;

public class UpdateTrigger
extends AbstractTrigger {
    private String schema;
    private String table;

    public void fire(Connection con, Object[] oldRow, Object[] newRow) throws SQLException {
        WKBEnvelope env;
        RTreeDml dml = RTreeDml.createDml(con, this.schema, this.table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        int pkI = dml.getPkColumnIndex();
        int geomI = dml.getGeomColumnIndex();
        Entry oldEntry = null;
        Entry newEntry = null;
        if (oldRow[geomI] != null) {
            env = null;
            try {
                env = this.getEnvelope(oldRow[geomI]);
            }
            catch (Exception e) {
                throw (SQLException)new SQLException("Failed to obtain geom for " + oldRow[pkI]).initCause(e);
            }
            oldEntry = new Entry(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), ((Number)oldRow[pkI]).longValue());
        }
        if (newRow[geomI] != null) {
            env = null;
            try {
                env = this.getEnvelope(newRow[geomI]);
            }
            catch (Exception e) {
                throw (SQLException)new SQLException("Failed to obtain geom for " + newRow[pkI]).initCause(e);
            }
            newEntry = new Entry(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), ((Number)newRow[pkI]).longValue());
        }
        if (newEntry == null || !newEntry.equals(oldEntry)) {
            if (oldEntry != null) {
                rTree.delete(oldEntry);
            }
            if (newEntry != null) {
                rTree.insert(newEntry);
            }
        }
        session.closeAll();
    }

    public void init(Connection con, String schema, String trigger, String table, boolean before, int type) throws SQLException {
        this.schema = schema;
        this.table = table;
    }
}

