/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.jts;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.Envelope;
import net.sourceforge.hatbox.IdResultSet;
import net.sourceforge.hatbox.IndexStatus;
import net.sourceforge.hatbox.InvalidTableException;
import net.sourceforge.hatbox.Lock;
import net.sourceforge.hatbox.MetaNode;
import net.sourceforge.hatbox.Node;
import net.sourceforge.hatbox.RTree;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeInternalException;
import net.sourceforge.hatbox.RTreeSessionDb;
import net.sourceforge.hatbox.SpatialPredicate;
import net.sourceforge.hatbox.jts.FilteredResultSet;
import net.sourceforge.hatbox.jts.ProgressMonitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class Proc {
    private static ThreadLocal<Entry> savedEntry = new ThreadLocal();

    private Proc() {
    }

    public static String getDefaultSchema(Connection con) throws SQLException {
        DatabaseMetaData meta = con.getMetaData();
        return meta.getUserName().toUpperCase();
    }

    public static MetaNode spatialMetaData(Connection con, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        PreparedStatement ps = con.prepareStatement(dml.getSelectIndex());
        ps.setLong(1, 1L);
        ResultSet rs = ps.executeQuery();
        rs.next();
        MetaNode meta = new MetaNode(rs.getBytes(1));
        rs.close();
        ps.close();
        return meta;
    }

    public static void spatializeProc(String schema, String table, String geomColumn, String geomType, String srid, String exposePK, String entriesMax) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        Proc.spatialize(con, schema, table, geomColumn, geomType, srid, exposePK, entriesMax);
    }

    public static void spatialize(Connection con, String schema, String table, String geomColumn, String geomType, String srid, String exposePK, String entriesMax) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        int pkColumnIndex = -1;
        int geomColumnIndex = -1;
        ArrayList<String> pkColList = new ArrayList<String>();
        DatabaseMetaData dbMetaData = con.getMetaData();
        ResultSet pkRs = dbMetaData.getPrimaryKeys(null, schema, table);
        while (pkRs.next()) {
            pkColList.add(pkRs.getString(4));
        }
        pkRs.close();
        if (pkColList.size() != 1) {
            throw new InvalidTableException("Table " + schema + "." + table + " has " + pkColList.size() + " PK columns - only allowed 1");
        }
        ResultSet colRs = dbMetaData.getColumns(null, schema, table, (String)pkColList.get(0));
        int colType = 0;
        if (colRs.next()) {
            colType = colRs.getInt(5);
            pkColumnIndex = colRs.getInt(17) - 1;
        }
        colRs.close();
        switch (colType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new InvalidTableException("Table " + schema + "." + table + " must have PK of SMALLINT, INTEGER or BIGINT");
            }
        }
        colRs = dbMetaData.getColumns(null, schema, table, geomColumn);
        colType = 0;
        if (colRs.next()) {
            colType = colRs.getInt(5);
            geomColumnIndex = colRs.getInt(17) - 1;
        }
        colRs.close();
        switch (colType) {
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw new InvalidTableException("Table " + schema + "." + table + " must have geometry column of BLOB, BINARY or VARBINARY");
            }
        }
        Statement stmt = con.createStatement();
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        MetaNode meta = new MetaNode(-1L, table, (String)pkColList.get(0), pkColumnIndex, geomColumn, geomColumnIndex, geomType, srid, exposePK, entriesMax);
        dml.setMetaNode(meta);
        stmt.executeUpdate(dml.getCreateIndex(meta.getIndexNodeSize(meta.getEntriesMax())));
        stmt.close();
        PreparedStatement ps = con.prepareStatement(dml.getInsertIndex());
        ps.setBytes(1, meta.getData());
        ps.execute();
        ps.close();
    }

    public static void buildIndexProc(String schema, String table, int commitInterval, ProgressMonitor progressMonitor) throws SQLException {
        Connection nested = DriverManager.getConnection("jdbc:default:connection");
        if (schema == null) {
            schema = Proc.getDefaultSchema(nested);
        }
        DatabaseMetaData dbMeta = nested.getMetaData();
        Connection con = DriverManager.getConnection(dbMeta.getURL());
        Proc.buildIndex(con, schema, table, commitInterval, progressMonitor);
    }

    public static void buildIndex(Connection con, String schema, String table, int commitInterval, ProgressMonitor progressMonitor) throws SQLException {
        con.setAutoCommit(false);
        Statement stmt = con.createStatement();
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        PreparedStatement ps = con.prepareStatement(dml.getSelectIndex());
        ps.setLong(1, 1L);
        ResultSet rs = ps.executeQuery();
        rs.next();
        MetaNode meta = new MetaNode(rs.getBytes(1));
        rs.close();
        ps.close();
        dml.setMetaNode(meta);
        stmt.executeUpdate(dml.getDeleteAllIndex());
        long rootId = -1L;
        ps = con.prepareStatement(dml.getInsertIndex(), 1);
        Node rootNode = new Node(0, -1L, meta.getEntriesMax());
        ps.setBytes(1, rootNode.getData());
        ps.execute();
        ResultSet keyRs = ps.getGeneratedKeys();
        if (!keyRs.next()) {
            throw new RTreeInternalException("No generated key returned from insert");
        }
        rootId = keyRs.getInt(1);
        ps.close();
        meta.setRootId(rootId);
        Proc.updateStatus(IndexStatus.BUILDING, dml, meta, con);
        if (progressMonitor != null) {
            progressMonitor.setRowsProcessed(0);
            progressMonitor.setCurrentIndexStatus(IndexStatus.BUILDING);
        }
        int rowsExpected = 0;
        try {
            try {
                stmt.executeUpdate("drop trigger " + dml.getInsTriggerName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.executeUpdate(dml.getCreateInsTrigger());
            try {
                stmt.executeUpdate("drop trigger " + dml.getBeforeUpdTriggerName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (dml.getCreateBeforeUpdTrigger().length() > 0) {
                stmt.executeUpdate(dml.getCreateBeforeUpdTrigger());
            }
            try {
                stmt.executeUpdate("drop trigger " + dml.getUpdTriggerName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.executeUpdate(dml.getCreateUpdTrigger());
            try {
                stmt.executeUpdate("drop trigger " + dml.getBeforeDelTriggerName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (dml.getCreateBeforeDelTrigger().length() > 0) {
                stmt.executeUpdate(dml.getCreateBeforeDelTrigger());
            }
            try {
                stmt.executeUpdate("drop trigger " + dml.getDelTriggerName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.executeUpdate(dml.getCreateDelTrigger());
            con.commit();
            RTreeSessionDb session = new RTreeSessionDb(con, dml, commitInterval);
            RTree rtree = new RTree(session);
            String selectCount = "select count(*) from " + dml.getFullTableName();
            ResultSet countRs = stmt.executeQuery(selectCount);
            if (countRs.next()) {
                rowsExpected = countRs.getInt(1);
            }
            countRs.close();
            if (progressMonitor != null) {
                progressMonitor.setRowsExpected(rowsExpected);
            }
            String select = "select \"" + dml.getPkColumn() + "\", \"" + dml.getGeomColumn() + "\" from " + dml.getFullTableName();
            ResultSet dataRs = stmt.executeQuery(select);
            int count = 0;
            WKBReader reader = new WKBReader();
            while (dataRs.next()) {
                if (progressMonitor != null && ++count % 1000 == 0) {
                    progressMonitor.setRowsProcessed(count);
                }
                long newId = dataRs.getLong(1);
                byte[] data = dataRs.getBytes(2);
                if (newId < 0L || data == null) continue;
                Geometry geom = null;
                try {
                    geom = reader.read(data);
                }
                catch (ParseException pe) {
                    throw new SQLException("Failed to parse geom for " + newId);
                }
                org.locationtech.jts.geom.Envelope e = geom.getEnvelopeInternal();
                Entry entry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), newId);
                rtree.insert(entry);
            }
            stmt.close();
            rootId = session.getRootId();
            meta.setRootId(rootId);
            Proc.updateStatus(IndexStatus.INDEXED, dml, meta, con);
        }
        catch (SQLException sqle) {
            Proc.updateStatus(IndexStatus.BUILD_FAILED, dml, meta, con);
            throw sqle;
        }
        catch (RuntimeException re) {
            Proc.updateStatus(IndexStatus.BUILD_FAILED, dml, meta, con);
            throw re;
        }
        if (progressMonitor != null) {
            progressMonitor.setRowsProcessed(rowsExpected);
            progressMonitor.setCurrentIndexStatus(IndexStatus.INDEXED);
        }
    }

    private static void updateStatus(IndexStatus status, RTreeDml dml, MetaNode meta, Connection con) throws SQLException {
        meta.setIndexStatus(status);
        PreparedStatement ps = con.prepareStatement(dml.getUpdateIndex());
        ps.setBytes(1, meta.getData());
        ps.setLong(2, 1L);
        ps.execute();
        ps.close();
        con.commit();
    }

    public static void deSpatializeProc(String schema, String table) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        Proc.deSpatialize(con, schema, table);
    }

    public static void deSpatialize(Connection con, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getTables(null, schema, table, new String[]{"TABLE"});
        if (!rs.next()) {
            throw new SQLException("Table " + schema + "." + table + " not found");
        }
        Statement stmt = con.createStatement();
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        try {
            stmt.executeUpdate("drop table " + dml.getIndexName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop trigger " + dml.getInsTriggerName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop trigger " + dml.getBeforeUpdTriggerName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop trigger " + dml.getUpdTriggerName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop trigger " + dml.getBeforeDelTriggerName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop trigger " + dml.getDelTriggerName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insSpatial(String schema, String table, long id) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        PreparedStatement ps = con.prepareStatement(dml.getSelectSpatial());
        ps.setLong(1, id);
        byte[] data = null;
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            data = rs.getBytes(1);
        }
        if (data != null) {
            WKBReader reader = new WKBReader();
            Geometry geom = null;
            try {
                geom = reader.read(data);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + id);
            }
            org.locationtech.jts.geom.Envelope e = geom.getEnvelopeInternal();
            Entry entry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), id);
            rTree.insert(entry);
        }
        ps.close();
    }

    public static void updSpatial(String schema, String table, long id) throws SQLException {
        Entry oldEntry = savedEntry.get();
        Entry newEntry = new Entry(id);
        if (oldEntry == null) {
            throw new SQLException("Found no saved entry for " + id);
        }
        if (oldEntry.getId() != newEntry.getId()) {
            throw new SQLException("Saved entry not found for " + id + " - found " + oldEntry.getId() + " instead");
        }
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        PreparedStatement ps = con.prepareStatement(dml.getSelectSpatial());
        ps.setLong(1, id);
        byte[] data = null;
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            data = rs.getBytes(1);
        }
        if (data != null) {
            WKBReader reader = new WKBReader();
            Geometry geom = null;
            try {
                geom = reader.read(data);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + id);
            }
            org.locationtech.jts.geom.Envelope e = geom.getEnvelopeInternal();
            newEntry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), id);
        }
        if (!oldEntry.equals(newEntry)) {
            if (!oldEntry.isNullGeometry()) {
                rTree.delete(oldEntry);
            }
            if (!newEntry.isNullGeometry()) {
                rTree.insert(newEntry);
            }
        }
        ps.close();
    }

    public static void delSpatial(String schema, String table, long id) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        Entry entry = savedEntry.get();
        if (entry == null) {
            throw new SQLException("Found no saved entry for " + id);
        }
        if (id != entry.getId()) {
            throw new SQLException("Saved entry not found for " + id + " - found " + entry.getId() + " instead");
        }
        if (!entry.isNullGeometry()) {
            rTree.delete(entry);
        }
    }

    public static void saveEntry(String schema, String table, long id) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        PreparedStatement select = con.prepareStatement(dml.getSelectIndex());
        Lock lock = new Lock(con, dml, select);
        lock.close();
        select.close();
        PreparedStatement ps = con.prepareStatement(dml.getSelectSpatial());
        ps.setLong(1, id);
        byte[] data = null;
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            data = rs.getBytes(1);
        }
        if (data == null) {
            savedEntry.set(new Entry(id));
        } else {
            WKBReader reader = new WKBReader();
            Geometry geom = null;
            try {
                geom = reader.read(data);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + id);
            }
            org.locationtech.jts.geom.Envelope e = geom.getEnvelopeInternal();
            Entry entry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), id);
            savedEntry.set(entry);
        }
        ps.close();
    }

    public static byte[] wktToWkb(String wkt) throws ParseException {
        WKTReader reader = new WKTReader();
        Geometry geom = reader.read(wkt);
        WKBWriter writer = new WKBWriter();
        return writer.write(geom);
    }

    public static String wkbToWkt(byte[] wkb) throws ParseException {
        WKBReader reader = new WKBReader();
        Geometry geom = reader.read(wkb);
        WKTWriter writer = new WKTWriter();
        return writer.write(geom);
    }

    public static ResultSet mbrIntersectsEnvFunc(String schema, String table, double minx, double maxx, double miny, double maxy) throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        return Proc.mbrIntersectsEnv(con, schema, table, minx, maxx, miny, maxy);
    }

    public static ResultSet mbrIntersectsEnv(Connection con, String schema, String table, double minx, double maxx, double miny, double maxy) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, false);
        ArrayList<Long> ids = null;
        if (dml.getMetaNode().getIndexStatus().equals((Object)IndexStatus.INDEXED)) {
            RTree rTree = new RTree(session);
            ids = rTree.search(new Envelope(minx, maxx, miny, maxy));
            return new IdResultSet(ids, schema, table);
        }
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(dml.getSelectAllPk());
        ids = new ArrayList();
        while (rs.next()) {
            ids.add(rs.getLong(1));
        }
        rs.close();
        stmt.close();
        GeometryFactory geomFactory = new GeometryFactory();
        CoordinateArraySequenceFactory factory = CoordinateArraySequenceFactory.instance();
        Coordinate[] coord = new Coordinate[]{new Coordinate(minx, miny), new Coordinate(maxx, miny), new Coordinate(maxx, maxy), new Coordinate(minx, maxy), new Coordinate(minx, miny)};
        Polygon queryGeom = new Polygon(new LinearRing(factory.create(coord), geomFactory), null, geomFactory);
        return new FilteredResultSet(ids, session, (Geometry)queryGeom, SpatialPredicate.INTERSECTS, schema, table);
    }

    public static ResultSet queryIntersectsWkbFunc(String schema, String table, byte[] wkb) throws SQLException, ParseException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        WKBReader reader = new WKBReader();
        Geometry queryGeom = reader.read(wkb);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.INTERSECTS, queryGeom);
    }

    public static ResultSet queryIntersectsWkb(Connection con, String schema, String table, byte[] wkb) throws SQLException, ParseException {
        WKBReader reader = new WKBReader();
        Geometry queryGeom = reader.read(wkb);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.INTERSECTS, queryGeom);
    }

    public static ResultSet queryIntersectsWktFunc(String schema, String table, String wkt) throws SQLException, ParseException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        WKTReader reader = new WKTReader();
        Geometry queryGeom = reader.read(wkt);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.INTERSECTS, queryGeom);
    }

    public static ResultSet queryIntersectsWkt(Connection con, String schema, String table, String wkt) throws SQLException, ParseException {
        WKTReader reader = new WKTReader();
        Geometry queryGeom = reader.read(wkt);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.INTERSECTS, queryGeom);
    }

    public static ResultSet queryWithPredicateWkbFunc(String schema, String table, String predicate, byte[] wkb) throws SQLException, ParseException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        WKBReader reader = new WKBReader();
        Geometry queryGeom = reader.read(wkb);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.valueOf(predicate.toUpperCase()), queryGeom);
    }

    public static ResultSet queryWithPredicateWkb(Connection con, String schema, String table, String predicate, byte[] wkb) throws SQLException, ParseException {
        WKBReader reader = new WKBReader();
        Geometry queryGeom = reader.read(wkb);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.valueOf(predicate.toUpperCase()), queryGeom);
    }

    public static ResultSet queryWithPredicateWktFunc(String schema, String table, String predicate, String wkt) throws SQLException, ParseException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        WKTReader reader = new WKTReader();
        Geometry queryGeom = reader.read(wkt);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.valueOf(predicate.toUpperCase()), queryGeom);
    }

    public static ResultSet queryWithPredicateWkt(Connection con, String schema, String table, String predicate, String wkt) throws SQLException, ParseException {
        WKTReader reader = new WKTReader();
        Geometry queryGeom = reader.read(wkt);
        return Proc.queryWithPredicate(con, schema, table, SpatialPredicate.valueOf(predicate.toUpperCase()), queryGeom);
    }

    private static ResultSet queryWithPredicate(Connection con, String schema, String table, SpatialPredicate predicate, Geometry queryGeom) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, false);
        List<Long> ids = null;
        if (dml.getMetaNode().getIndexStatus().equals((Object)IndexStatus.INDEXED)) {
            RTree rTree = new RTree(session);
            Envelope queryEnv = null;
            if (SpatialPredicate.DISJOINT.equals((Object)predicate)) {
                queryEnv = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            } else {
                org.locationtech.jts.geom.Envelope e = queryGeom.getEnvelopeInternal();
                queryEnv = new Envelope(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY());
            }
            ids = rTree.search(queryEnv);
        } else {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(dml.getSelectAllPk());
            ids = new ArrayList<Long>();
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
            rs.close();
            stmt.close();
        }
        return new FilteredResultSet(ids, session, queryGeom, predicate, schema, table);
    }

    public static org.locationtech.jts.geom.Envelope getDatasetBounds(Connection con, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = Proc.getDefaultSchema(con);
        }
        RTreeDml dml = RTreeDml.createDml(con, schema, table);
        RTreeSessionDb session = null;
        try {
            session = new RTreeSessionDb(con, dml, false);
        }
        catch (SQLException sqle) {
            return new org.locationtech.jts.geom.Envelope();
        }
        long rootId = session.getRootId();
        if (rootId < 0L) {
            org.locationtech.jts.geom.Envelope jtsEnv = new org.locationtech.jts.geom.Envelope();
            WKBReader reader = new WKBReader();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(dml.getSelectAllSpatial());
            while (rs.next()) {
                try {
                    jtsEnv.expandToInclude(reader.read(rs.getBytes(1)).getEnvelopeInternal());
                }
                catch (ParseException parseException) {}
            }
            rs.close();
            stmt.close();
            return jtsEnv;
        }
        Envelope env = session.getNode(rootId).getBounds();
        return new org.locationtech.jts.geom.Envelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }
}

