/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.hatbox.Lock;
import net.sourceforge.hatbox.Node;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeInternalException;
import net.sourceforge.hatbox.RTreeSession;

public class RTreeSessionDb
implements RTreeSession {
    private Connection con;
    private PreparedStatement selectSpatialStmt;
    private PreparedStatement selectStmt;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private RTreeDml dml;
    private Lock lock;
    private int commitInterval = 0;
    private int dmlCount = 0;

    public RTreeSessionDb(Connection con, RTreeDml dml, int commitInterval) throws SQLException {
        this.con = con;
        this.dml = dml;
        this.commitInterval = commitInterval;
    }

    public RTreeSessionDb(Connection con, RTreeDml dml, boolean write) throws SQLException {
        this.con = con;
        this.dml = dml;
        if (write) {
            this.lock = new Lock(con, dml);
        } else {
            this.selectStmt = con.prepareStatement(dml.getSelectIndex());
            this.lock = new Lock(con, dml, this.selectStmt);
        }
    }

    @Override
    public long getRootId() throws SQLException {
        return this.dml.getMetaNode().getRootId();
    }

    @Override
    public void setRootId(long id) throws SQLException {
        this.dml.getMetaNode().setRootId(id);
        if (this.lock == null) {
            if (this.updateStmt == null) {
                this.updateStmt = this.con.prepareStatement(this.dml.getUpdateIndex());
            }
            this.updateStmt.setBytes(1, this.dml.getMetaNode().getData());
            this.updateStmt.setLong(2, 1L);
            this.updateStmt.executeUpdate();
        } else {
            this.lock.setRootId(id);
        }
    }

    public Connection getCon() {
        return this.con;
    }

    public void setCon(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        PreparedStatement preparedStatement;
        if (this.lock != null) {
            try {
                this.lock.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.lock = null;
        }
        if (this.selectStmt != null) {
            preparedStatement = this.selectStmt;
            synchronized (preparedStatement) {
                try {
                    this.selectStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.selectStmt = null;
            }
        }
        if (this.selectSpatialStmt != null) {
            preparedStatement = this.selectSpatialStmt;
            synchronized (preparedStatement) {
                try {
                    this.selectSpatialStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.selectSpatialStmt = null;
            }
        }
        if (this.insertStmt != null) {
            preparedStatement = this.insertStmt;
            synchronized (preparedStatement) {
                try {
                    this.insertStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.insertStmt = null;
            }
        }
        if (this.updateStmt != null) {
            preparedStatement = this.updateStmt;
            synchronized (preparedStatement) {
                try {
                    this.updateStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.updateStmt = null;
            }
        }
        if (this.deleteStmt != null) {
            preparedStatement = this.deleteStmt;
            synchronized (preparedStatement) {
                try {
                    this.deleteStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.deleteStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(long id) throws SQLException {
        Node node = null;
        if (this.selectStmt == null) {
            this.selectStmt = this.con.prepareStatement(this.dml.getSelectIndex());
        }
        PreparedStatement preparedStatement = this.selectStmt;
        synchronized (preparedStatement) {
            try {
                this.selectStmt.setLong(1, id);
                ResultSet rs = this.selectStmt.executeQuery();
                if (!rs.next()) {
                    throw new RTreeInternalException(id + " not found in database");
                }
                byte[] data = rs.getBytes(1);
                node = new Node(id, data);
            }
            catch (SQLException sqle) {
                try {
                    this.selectStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.selectStmt = null;
                throw sqle;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertNode(Node node) throws SQLException {
        int id = 0;
        if (this.insertStmt == null) {
            this.insertStmt = this.con.prepareStatement(this.dml.getInsertIndex(), 1);
        }
        PreparedStatement preparedStatement = this.insertStmt;
        synchronized (preparedStatement) {
            try {
                ResultSet keyRs;
                this.insertStmt.setBytes(1, node.getData());
                int rows = this.insertStmt.executeUpdate();
                if (rows == 1) {
                    keyRs = this.insertStmt.getGeneratedKeys();
                    if (!keyRs.next()) {
                        throw new RTreeInternalException("No generated key returned from insert");
                    }
                } else {
                    throw new RTreeInternalException("No index node inserted");
                }
                id = keyRs.getInt(1);
                node.setId(id);
                if (this.commitInterval > 0) {
                    ++this.dmlCount;
                    if (this.dmlCount % this.commitInterval == 0) {
                        this.con.commit();
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.insertStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.insertStmt = null;
                throw sqle;
            }
        }
        node.setDirty(false);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNode(Node node) throws SQLException {
        if (this.updateStmt == null) {
            this.updateStmt = this.con.prepareStatement(this.dml.getUpdateIndex());
        }
        PreparedStatement preparedStatement = this.updateStmt;
        synchronized (preparedStatement) {
            try {
                this.updateStmt.setBytes(1, node.getData());
                this.updateStmt.setLong(2, node.getId());
                int rows = this.updateStmt.executeUpdate();
                if (rows != 1) {
                    throw new RTreeInternalException("No rows updated for key: " + node.getId());
                }
                if (this.commitInterval > 0) {
                    ++this.dmlCount;
                    if (this.dmlCount % this.commitInterval == 0) {
                        this.con.commit();
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.updateStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.updateStmt = null;
                throw sqle;
            }
        }
        node.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(Node node) throws SQLException {
        if (this.deleteStmt == null) {
            this.deleteStmt = this.con.prepareStatement(this.dml.getDeleteIndex());
        }
        PreparedStatement preparedStatement = this.deleteStmt;
        synchronized (preparedStatement) {
            try {
                this.deleteStmt.setLong(1, node.getId());
            }
            catch (SQLException sqle) {
                try {
                    this.deleteStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.deleteStmt = null;
                throw sqle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getWKB(long id) throws SQLException {
        byte[] bytes = null;
        if (this.selectSpatialStmt == null) {
            this.selectSpatialStmt = this.con.prepareStatement(this.dml.getSelectSpatial());
        }
        PreparedStatement preparedStatement = this.selectSpatialStmt;
        synchronized (preparedStatement) {
            this.selectSpatialStmt.setLong(1, id);
            ResultSet rs = null;
            try {
                rs = this.selectSpatialStmt.executeQuery();
                if (rs.next()) {
                    bytes = rs.getBytes(1);
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return bytes;
    }
}

