/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import net.sourceforge.hatbox.RTreeDml;

public class RTreeDmlDerby
extends RTreeDml {
    public RTreeDmlDerby(String schema, String table) {
        super(schema, table);
    }

    @Override
    public String createSelectAllPk() {
        return "select \"" + this.getPkColumn() + "\" from " + this.getFullTableName();
    }

    @Override
    public String createSelectSpatial() {
        return "select \"" + this.getGeomColumn() + "\" from " + this.getFullTableName() + " where \"" + this.getPkColumn() + "\" = ?";
    }

    @Override
    public String createSelectAllSpatial() {
        return "select \"" + this.getGeomColumn() + "\" from " + this.getFullTableName();
    }

    @Override
    public String createCreateIndex(int nodeStorageSize) {
        return "create table " + this.getIndexName() + " (id bigint not null generated always as identity,  node_data varchar(" + nodeStorageSize + ") for bit data not null,  primary key (id))";
    }

    @Override
    public String createCreateInsTrigger() {
        return "create trigger " + this.getInsTriggerName() + " after insert on " + this.getFullTableName() + " referencing NEW as INS  for each row  call HATBOX.INS_SPATIAL_PROC( '" + this.schema + "', '" + this.table + "', INS.\"" + this.getPkColumn() + "\")";
    }

    @Override
    public String createCreateBeforeDelTrigger() {
        return "create trigger " + this.getBeforeDelTriggerName() + " no cascade before delete on " + this.getFullTableName() + " referencing OLD as DEL  for each row  call HATBOX.SAVE_ENTRY_PROC( '" + this.schema + "', '" + this.table + "', DEL.\"" + this.getPkColumn() + "\")";
    }

    @Override
    public String createCreateDelTrigger() {
        return "create trigger " + this.getDelTriggerName() + " after delete on " + this.getFullTableName() + " referencing OLD as DEL  for each row  call HATBOX.DEL_SPATIAL_PROC( '" + this.schema + "', '" + this.table + "', DEL.\"" + this.getPkColumn() + "\")";
    }

    @Override
    public String createCreateBeforeUpdTrigger() {
        return "create trigger " + this.getBeforeUpdTriggerName() + " no cascade before update on " + this.getFullTableName() + " referencing NEW as UPD  for each row  call HATBOX.SAVE_ENTRY_PROC( '" + this.schema + "', '" + this.table + "', UPD.\"" + this.getPkColumn() + "\")";
    }

    @Override
    public String createCreateUpdTrigger() {
        return "create trigger " + this.getUpdTriggerName() + " after update on " + this.getFullTableName() + " referencing NEW as UPD  for each row  call HATBOX.UPD_SPATIAL_PROC( '" + this.schema + "', '" + this.table + "', UPD.\"" + this.getPkColumn() + "\")";
    }

    @Override
    public String createSelectIndex() {
        return "select node_data from " + this.getIndexName() + " where id = ?";
    }

    @Override
    public String createInsertIndex() {
        return "insert into " + this.getIndexName() + "  (node_data) values (?)";
    }

    @Override
    public String createUpdateIndex() {
        return "update " + this.getIndexName() + " set node_data = ? where id = ?";
    }

    @Override
    public String createDeleteIndex() {
        return "delete from " + this.getIndexName() + " where id = ?";
    }

    @Override
    public String createDeleteAllIndex() {
        return "delete from " + this.getIndexName() + " where id > " + 1L;
    }
}

