/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.hatbox.MetaNode;
import net.sourceforge.hatbox.RTreeDmlDerby;
import net.sourceforge.hatbox.RTreeDmlH2;

public abstract class RTreeDml {
    public static final long META_NODE_ID = 1L;
    public static final int NODE_DATA_COL = 1;
    public static final int ID_COL = 1;
    public static final int UPDATE_ID_COL = 2;
    private MetaNode metaNode;
    protected String schema;
    protected String table;
    private String selectAllPk;
    private String selectSpatial;
    private String selectAllSpatial;
    private String createInsTrigger;
    private String createBeforeUpdTrigger;
    private String createUpdTrigger;
    private String createBeforeDelTrigger;
    private String createDelTrigger;
    private String selectIndex;
    private String insertIndex;
    private String updateIndex;
    private String deleteIndex;
    private String deleteAllIndex;

    protected RTreeDml(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }

    public static RTreeDml createDml(Connection con, String schema, String table) throws SQLException {
        String product = con.getMetaData().getDatabaseProductName();
        if (product.equals("Apache Derby")) {
            return new RTreeDmlDerby(schema, table);
        }
        if (product.equals("H2")) {
            return new RTreeDmlH2(schema, table);
        }
        throw new IllegalArgumentException("Not a Derby or H2 Connection: " + product);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getPkColumn() {
        return this.metaNode.getPkColName();
    }

    public int getPkColumnIndex() {
        return this.metaNode.getPkColIndex();
    }

    public String getGeomColumn() {
        return this.metaNode.getGeomColName();
    }

    public int getGeomColumnIndex() {
        return this.metaNode.getGeomColIndex();
    }

    public MetaNode getMetaNode() {
        return this.metaNode;
    }

    public void setMetaNode(MetaNode metaNode) {
        this.metaNode = metaNode;
    }

    public String getFullTableName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append('\"');
        return buf.toString();
    }

    public String getIndexName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_HATBOX").append('\"');
        return buf.toString();
    }

    public String getInsTriggerName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_INSTRG").append('\"');
        return buf.toString();
    }

    public String getUpdTriggerName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_UPDTRG").append('\"');
        return buf.toString();
    }

    public String getBeforeUpdTriggerName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_UPD_BT").append('\"');
        return buf.toString();
    }

    public String getDelTriggerName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_DELTRG").append('\"');
        return buf.toString();
    }

    public String getBeforeDelTriggerName() {
        StringBuilder buf = new StringBuilder();
        buf.append('\"').append(this.schema).append('\"').append('.').append('\"').append(this.table).append("_DEL_BT").append('\"');
        return buf.toString();
    }

    public String getSelectAllPk() {
        if (this.selectAllPk == null) {
            this.selectAllPk = this.createSelectAllPk();
        }
        return this.selectAllPk;
    }

    public abstract String createSelectAllPk();

    public String getSelectSpatial() {
        if (this.selectSpatial == null) {
            this.selectSpatial = this.createSelectSpatial();
        }
        return this.selectSpatial;
    }

    public abstract String createSelectSpatial();

    public String getSelectAllSpatial() {
        if (this.selectAllSpatial == null) {
            this.selectAllSpatial = this.createSelectAllSpatial();
        }
        return this.selectAllSpatial;
    }

    public abstract String createSelectAllSpatial();

    public String getCreateIndex(int nodeStorageSize) {
        return this.createCreateIndex(nodeStorageSize);
    }

    public abstract String createCreateIndex(int var1);

    public String getCreateInsTrigger() {
        if (this.createInsTrigger == null) {
            this.createInsTrigger = this.createCreateInsTrigger();
        }
        return this.createInsTrigger;
    }

    public abstract String createCreateInsTrigger();

    public String getCreateDelTrigger() {
        if (this.createDelTrigger == null) {
            this.createDelTrigger = this.createCreateDelTrigger();
        }
        return this.createDelTrigger;
    }

    public abstract String createCreateDelTrigger();

    public String getCreateBeforeDelTrigger() {
        if (this.createBeforeDelTrigger == null) {
            this.createBeforeDelTrigger = this.createCreateBeforeDelTrigger();
        }
        return this.createBeforeDelTrigger;
    }

    public abstract String createCreateBeforeDelTrigger();

    public String getCreateUpdTrigger() {
        if (this.createUpdTrigger == null) {
            this.createUpdTrigger = this.createCreateUpdTrigger();
        }
        return this.createUpdTrigger;
    }

    public abstract String createCreateUpdTrigger();

    public String getCreateBeforeUpdTrigger() {
        if (this.createBeforeUpdTrigger == null) {
            this.createBeforeUpdTrigger = this.createCreateBeforeUpdTrigger();
        }
        return this.createBeforeUpdTrigger;
    }

    public abstract String createCreateBeforeUpdTrigger();

    public String getSelectIndex() {
        if (this.selectIndex == null) {
            this.selectIndex = this.createSelectIndex();
        }
        return this.selectIndex;
    }

    public abstract String createSelectIndex();

    public String getInsertIndex() {
        if (this.insertIndex == null) {
            this.insertIndex = this.createInsertIndex();
        }
        return this.insertIndex;
    }

    public abstract String createInsertIndex();

    public String getUpdateIndex() {
        if (this.updateIndex == null) {
            this.updateIndex = this.createUpdateIndex();
        }
        return this.updateIndex;
    }

    public abstract String createUpdateIndex();

    public String getDeleteIndex() {
        if (this.deleteIndex == null) {
            this.deleteIndex = this.createDeleteIndex();
        }
        return this.deleteIndex;
    }

    public abstract String createDeleteIndex();

    public String getDeleteAllIndex() {
        if (this.deleteAllIndex == null) {
            this.deleteAllIndex = this.createDeleteAllIndex();
        }
        return this.deleteAllIndex;
    }

    public abstract String createDeleteAllIndex();
}

