/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import net.sourceforge.hatbox.AbstractNode;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.Envelope;
import net.sourceforge.hatbox.RTreeInternalException;

public class Node
extends AbstractNode {
    private int MIN_X_OFFSET;
    private int MAX_X_OFFSET;
    private int MIN_Y_OFFSET;
    private int MAX_Y_OFFSET;

    public Node(long id, byte[] data) {
        super(id, data);
        int entriesMax = this.getEntriesMax();
        this.MIN_X_OFFSET = 48 + entriesMax * 8;
        this.MAX_X_OFFSET = this.MIN_X_OFFSET + entriesMax * 8;
        this.MIN_Y_OFFSET = this.MAX_X_OFFSET + entriesMax * 8;
        this.MAX_Y_OFFSET = this.MIN_Y_OFFSET + entriesMax * 8;
    }

    public Node(int level, long parentId, int entriesMax) {
        this.MIN_X_OFFSET = 48 + entriesMax * 8;
        this.MAX_X_OFFSET = this.MIN_X_OFFSET + entriesMax * 8;
        this.MIN_Y_OFFSET = this.MAX_X_OFFSET + entriesMax * 8;
        this.MAX_Y_OFFSET = this.MIN_Y_OFFSET + entriesMax * 8;
        this.data = new byte[this.getIndexNodeSize(entriesMax)];
        this.setParentId(parentId);
        this.setLevel(level);
        this.setEntriesCount(0);
        this.setEntriesMax(entriesMax);
        this.putDouble(Double.POSITIVE_INFINITY, 16);
        this.putDouble(Double.NEGATIVE_INFINITY, 24);
        this.putDouble(Double.POSITIVE_INFINITY, 32);
        this.putDouble(Double.NEGATIVE_INFINITY, 40);
    }

    public Node split() {
        return new Node(this.getLevel(), this.getParentId(), this.getEntriesMax());
    }

    public long getParentId() {
        return this.getLong(0);
    }

    public void setParentId(long parentId) {
        this.putLong(parentId, 0);
        this.dirty = true;
    }

    public boolean isIdAllocated() {
        return this.id >= 0L;
    }

    public Envelope getBounds() {
        return new Envelope(this.getDouble(16), this.getDouble(24), this.getDouble(32), this.getDouble(40));
    }

    public Entry getMyEntry() {
        return new Entry(this.getDouble(16), this.getDouble(24), this.getDouble(32), this.getDouble(40), this.id, this.getShort(8) + 1);
    }

    public void resetEntries() {
        this.setEntriesCount(0);
        this.putDouble(Double.POSITIVE_INFINITY, 16);
        this.putDouble(Double.NEGATIVE_INFINITY, 24);
        this.putDouble(Double.POSITIVE_INFINITY, 32);
        this.putDouble(Double.NEGATIVE_INFINITY, 40);
        this.dirty = true;
    }

    public void addEntry(Entry entry) {
        int entriesCount = this.getEntriesCount();
        this.putEntryId(entry.getId(), entriesCount);
        this.putEntryMinX(entry.getMinX(), entriesCount);
        this.putEntryMaxX(entry.getMaxX(), entriesCount);
        this.putEntryMinY(entry.getMinY(), entriesCount);
        this.putEntryMaxY(entry.getMaxY(), entriesCount);
        this.setEntriesCount(entriesCount + 1);
        Envelope bounds = this.getBounds();
        bounds.expandToFit(entry);
        this.putDouble(bounds.getMinX(), 16);
        this.putDouble(bounds.getMaxX(), 24);
        this.putDouble(bounds.getMinY(), 32);
        this.putDouble(bounds.getMaxY(), 40);
        this.dirty = true;
    }

    public void changeEntryEnvelope(Entry entry) {
        int idIndex = this.getEntryIndex(entry.getId());
        this.putEntryMinX(entry.getMinX(), idIndex);
        this.putEntryMaxX(entry.getMaxX(), idIndex);
        this.putEntryMinY(entry.getMinY(), idIndex);
        this.putEntryMaxY(entry.getMaxY(), idIndex);
        this.recalcBounds();
        this.dirty = true;
    }

    public void removeEntry(long entryId) {
        int last;
        int idIndex = this.getEntryIndex(entryId);
        if (idIndex < (last = this.getEntriesMax() - 1)) {
            System.arraycopy(this.data, 48 + (idIndex + 1) * 8, this.data, 48 + idIndex * 8, (last - idIndex) * 8);
            System.arraycopy(this.data, this.MIN_X_OFFSET + (idIndex + 1) * 8, this.data, this.MIN_X_OFFSET + idIndex * 8, (last - idIndex) * 8);
            System.arraycopy(this.data, this.MAX_X_OFFSET + (idIndex + 1) * 8, this.data, this.MAX_X_OFFSET + idIndex * 8, (last - idIndex) * 8);
            System.arraycopy(this.data, this.MIN_Y_OFFSET + (idIndex + 1) * 8, this.data, this.MIN_Y_OFFSET + idIndex * 8, (last - idIndex) * 8);
            System.arraycopy(this.data, this.MAX_Y_OFFSET + (idIndex + 1) * 8, this.data, this.MAX_Y_OFFSET + idIndex * 8, (last - idIndex) * 8);
        }
        this.setEntriesCount(this.getEntriesCount() - 1);
        this.recalcBounds();
        this.dirty = true;
    }

    private int getEntryIndex(long id) {
        int entriesCount = this.getEntriesCount();
        for (int i = 0; i < entriesCount; ++i) {
            if (this.getEntryId(i) != id) continue;
            return i;
        }
        throw new RTreeInternalException("Node " + this.id + " does not contain entry id " + id);
    }

    private void recalcBounds() {
        Envelope bounds = new Envelope();
        int entriesCount = this.getEntriesCount();
        for (int i = 0; i < entriesCount; ++i) {
            double minx = this.getEntryMinX(i);
            double maxx = this.getEntryMaxX(i);
            double miny = this.getEntryMinY(i);
            double maxy = this.getEntryMaxY(i);
            bounds.expandToFit(minx, maxx, miny, maxy);
        }
        this.putDouble(bounds.getMinX(), 16);
        this.putDouble(bounds.getMaxX(), 24);
        this.putDouble(bounds.getMinY(), 32);
        this.putDouble(bounds.getMaxY(), 40);
    }

    public boolean isLeaf() {
        return this.getLevel() == 0;
    }

    public int getLevel() {
        return this.getShort(8);
    }

    public void setLevel(int level) {
        this.putShort(level, 8);
    }

    public int getEntriesCount() {
        return this.getShort(10);
    }

    private void setEntriesCount(int count) {
        this.putShort(count, 10);
    }

    public int getEntriesMax() {
        return this.getShort(12);
    }

    private void setEntriesMax(int entriesMax) {
        this.putShort(entriesMax, 12);
    }

    public double populateEnvelope(Envelope envelope, int entryIndex) {
        return envelope.populate(this.getEntryMinX(entryIndex), this.getEntryMaxX(entryIndex), this.getEntryMinY(entryIndex), this.getEntryMaxY(entryIndex));
    }

    public final boolean intersects(Envelope search, int entryIndex) {
        return !(search.getMaxX() < this.getEntryMinX(entryIndex) || search.getMinX() > this.getEntryMaxX(entryIndex) || search.getMaxY() < this.getEntryMinY(entryIndex) || search.getMinY() > this.getEntryMaxY(entryIndex));
    }

    public final long getEntryId(int i) {
        return this.getLong(48 + i * 8);
    }

    public final double getEntryMinX(int i) {
        return this.getDouble(this.MIN_X_OFFSET + i * 8);
    }

    public final double getEntryMaxX(int i) {
        return this.getDouble(this.MAX_X_OFFSET + i * 8);
    }

    public final double getEntryMinY(int i) {
        return this.getDouble(this.MIN_Y_OFFSET + i * 8);
    }

    public final double getEntryMaxY(int i) {
        return this.getDouble(this.MAX_Y_OFFSET + i * 8);
    }

    public final void putEntryId(long id, int i) {
        this.putLong(id, 48 + i * 8);
    }

    public final void putEntryMinX(double minX, int i) {
        this.putDouble(minX, this.MIN_X_OFFSET + i * 8);
    }

    public final void putEntryMaxX(double maxX, int i) {
        this.putDouble(maxX, this.MAX_X_OFFSET + i * 8);
    }

    public final void putEntryMinY(double minY, int i) {
        this.putDouble(minY, this.MIN_Y_OFFSET + i * 8);
    }

    public final void putEntryMaxY(double maxY, int i) {
        this.putDouble(maxY, this.MAX_Y_OFFSET + i * 8);
    }

    public Entry getEntry(int i) {
        return new Entry(this.getEntryMinX(i), this.getEntryMaxX(i), this.getEntryMinY(i), this.getEntryMaxY(i), this.getEntryId(i), this.getLevel());
    }

    public int getMinNodeEntries(double minNodeSplit) {
        return (int)((double)this.getEntriesMax() * minNodeSplit);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Id:");
        buf.append(this.id);
        buf.append(" Parent:");
        buf.append(this.getParentId());
        buf.append(this.getLevel() == 0 ? " Leaf " : " Index-" + this.getLevel() + " ");
        int entriesCount = this.getEntriesCount();
        buf.append("Entries:");
        buf.append(entriesCount);
        buf.append(" Max:");
        buf.append(this.getEntriesMax());
        buf.append(" {");
        for (int i = 0; i < entriesCount; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            Entry entry = this.getEntry(i);
            buf.append(entry.getId());
            buf.append("*");
            buf.append(entry.getMinX());
            buf.append(":");
            buf.append(entry.getMaxX());
            buf.append(":");
            buf.append(entry.getMinY());
            buf.append(":");
            buf.append(entry.getMaxY());
        }
        buf.append("}");
        return buf.toString();
    }
}

