/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.catalog;

import java.io.IOException;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class CoverageSlicesCatalogSource
implements GranuleSource {
    private CoverageSlicesCatalog innerCatalog;
    private final String typeName;

    public CoverageSlicesCatalogSource(CoverageSlicesCatalog innerCatalog, String typeName) {
        this.innerCatalog = innerCatalog;
        this.typeName = typeName;
    }

    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        if (q == null) {
            q = new Query(this.typeName);
        } else {
            q.setTypeName(this.typeName);
        }
        Filter filter = q.getFilter();
        q.setFilter(filter);
        List<CoverageSlice> granules = this.innerCatalog.getGranules(q);
        ListFeatureCollection collection = new ListFeatureCollection(this.innerCatalog.getSchema(this.typeName));
        for (CoverageSlice granule : granules) {
            collection.add(granule.getOriginator());
        }
        return collection;
    }

    public int getCount(Query q) throws IOException {
        return this.innerCatalog.getGranules(q).size();
    }

    public ReferencedEnvelope getBounds(Query q) throws IOException {
        return this.getGranules(q).getBounds();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.innerCatalog.getSchema(this.typeName);
    }

    public void dispose() throws IOException {
    }
}

