/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public abstract class BaseDirectoryStrategy {
    private static final Logger LOGGER = Logging.getLogger(BaseDirectoryStrategy.class);

    public abstract File getBaseDirectory(File var1);

    public static BaseDirectoryStrategy createStrategy() {
        File externalDir = BaseDirectoryStrategy.getSystemPropertyDirectory("NETCDF_DATA_DIR");
        if (externalDir == null) {
            return new SidecarDirectoryStrategy();
        }
        boolean tree = Boolean.getBoolean("NETCDF_DATA_DIR_TREE");
        if (!tree) {
            return new FlatDirectoryStrategy(externalDir);
        }
        File rootDir = BaseDirectoryStrategy.getSystemPropertyDirectory("NETCDF_ROOT");
        if (rootDir == null) {
            return new HierarchicalDirectoryStrategy(externalDir);
        }
        return new HierarchicalRelativeDirectoryStrategy(externalDir, rootDir);
    }

    static String sanitizeWindowsPath(String absolutePath) {
        return absolutePath.replace(":", "");
    }

    static File getSystemPropertyDirectory(String propertyName) {
        return Optional.ofNullable(System.getProperty(propertyName)).map(p -> new File((String)p)).filter(f -> BaseDirectoryStrategy.isValidDir(f, propertyName)).orElse(null);
    }

    private static boolean isValidDir(File file, String dirPropertyName) {
        String dir = file.getAbsolutePath();
        if (!file.exists()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified " + dirPropertyName + " property doesn't refer to an existing folder. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.isDirectory()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified " + dirPropertyName + " property doesn't refer to a directory. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.canWrite()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified " + dirPropertyName + " property refers to a directory which can't be written. Please check the path and the permissions for: " + dir);
            }
            return false;
        }
        return true;
    }

    private static class HierarchicalRelativeDirectoryStrategy
    extends BaseDirectoryStrategy {
        private final File externalDirectory;
        private final File netcdfRoot;

        public HierarchicalRelativeDirectoryStrategy(File externalDirectory, File netcdfRoot) {
            this.externalDirectory = externalDirectory;
            this.netcdfRoot = netcdfRoot;
        }

        @Override
        public File getBaseDirectory(File parentDirectory) {
            Path relative = this.netcdfRoot.toPath().relativize(parentDirectory.toPath());
            return new File(this.externalDirectory, relative.toString());
        }
    }

    private static class HierarchicalDirectoryStrategy
    extends BaseDirectoryStrategy {
        private final File externalDirectory;

        public HierarchicalDirectoryStrategy(File externalDirectory) {
            this.externalDirectory = externalDirectory;
        }

        @Override
        public File getBaseDirectory(File parentDirectory) {
            return new File(this.externalDirectory, HierarchicalDirectoryStrategy.sanitizeWindowsPath(parentDirectory.getAbsolutePath()));
        }
    }

    private static class FlatDirectoryStrategy
    extends BaseDirectoryStrategy {
        private final File externalDirectory;

        public FlatDirectoryStrategy(File externalDirectory) {
            this.externalDirectory = externalDirectory;
        }

        @Override
        public File getBaseDirectory(File parentDirectory) {
            return this.externalDirectory;
        }
    }

    private static class SidecarDirectoryStrategy
    extends BaseDirectoryStrategy {
        private SidecarDirectoryStrategy() {
        }

        @Override
        public File getBaseDirectory(File parentDirectory) {
            return parentDirectory;
        }
    }
}

