/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.util.NumericConverterFactory;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.util.Converter;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;

class NumericCoordinateVariable<T extends Number>
extends CoordinateVariable<T> {
    private double scaleFactor = Double.NaN;
    private double offsetFactor = Double.NaN;
    private Converter converter;
    private static final NumericConverterFactory CONVERTER_FACTORY = new NumericConverterFactory();

    public NumericCoordinateVariable(Class<T> binding, CoordinateAxis coordinateAxis) {
        super(binding, coordinateAxis);
        Attribute offsetFactor;
        if (!coordinateAxis.isNumeric()) {
            throw new IllegalArgumentException("Unable to process non numeric coordinate variable: " + coordinateAxis.toString());
        }
        Attribute scaleFactor = coordinateAxis.findAttribute("scale_factor");
        if (scaleFactor != null) {
            this.scaleFactor = scaleFactor.getNumericValue().doubleValue();
        }
        if ((offsetFactor = coordinateAxis.findAttribute("offset")) != null) {
            this.offsetFactor = offsetFactor.getNumericValue().doubleValue();
        }
        this.converter = CONVERTER_FACTORY.createConverter(Double.class, this.binding, null);
        this.init();
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    protected synchronized CoordinateReferenceSystem buildCoordinateReferenceSystem() {
        AxisType axisType = this.coordinateAxis.getAxisType();
        switch (axisType) {
            case GeoZ: 
            case Height: 
            case Pressure: {
                String axisName = this.getName();
                if (!NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(axisName)) break;
                return NetCDFCRSUtilities.buildVerticalCrs(this.coordinateAxis);
            }
        }
        return null;
    }

    @Override
    protected T convertValue(Object o) {
        double val = ((Number)o).doubleValue();
        if (!Double.isNaN(this.scaleFactor)) {
            val *= this.scaleFactor;
        }
        if (!Double.isNaN(this.offsetFactor)) {
            val += this.offsetFactor;
        }
        try {
            return (T)((Number)this.converter.convert((Object)val, this.binding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

