/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.coverage.SampleDimension;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.DefaultDimensionDescriptor;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.CoverageSourceDescriptor;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.range.impl.DefaultFieldType;
import org.geotools.coverage.io.range.impl.DefaultRangeType;
import org.geotools.coverage.io.util.DateRangeComparator;
import org.geotools.coverage.io.util.DateRangeTreeSet;
import org.geotools.coverage.io.util.DoubleRangeTreeSet;
import org.geotools.coverage.io.util.NumberRangeComparator;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.imageio.netcdf.MultipleBandsDimensionInfo;
import org.geotools.imageio.netcdf.NetCDFGeoreferenceManager;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.NetCDFUnitFormat;
import org.geotools.imageio.netcdf.Slice2DIndex;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class VariableAdapter
extends CoverageSourceDescriptor {
    private static final boolean QUICK_SCAN;
    private static final String QUICK_SCAN_KEY = "org.geotools.netcdf.quickscan";
    private static final CoordinateAxis.AxisComparator AXIS_COMPARATOR;
    public static final int Z = 0;
    public static final int T = 1;
    private static final Map<String, Unit> UNITS_CACHE;
    static final Set<UnitCharReplacement> UNIT_CHARS_REPLACEMENTS;
    final VariableDS variableDS;
    Set<String> ignoredDimensions = new HashSet<String>();
    private CoordinateSystem coordinateSystem;
    private NetCDFImageReader reader;
    private int numBands;
    private SampleModel sampleModel;
    private int numberOfSlices;
    private int width;
    private int height;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private Name coverageName;
    private int[] nDimensionIndex;
    private static final Logger LOGGER;
    private static final int FIRST_ATTRIBUTE_INDEX = 2;

    private void init() throws Exception {
        this.initSpatialElements();
        this.initRange();
        this.initSlicesInfo();
    }

    public int getRank() {
        return this.variableDS.getRank() - this.ignoredDimensions.size();
    }

    private void initSlicesInfo() {
        int[] shape = this.variableDS.getShape();
        this.numberOfSlices = 1;
        for (int i = 0; i < this.variableDS.getShape().length - 2; ++i) {
            if (this.ignoredDimensions.contains(this.variableDS.getDimension(i).getFullName())) continue;
            this.numberOfSlices *= shape[i];
        }
    }

    private void initSpatialElements() throws Exception {
        ArrayList<DimensionDescriptor> dimensions = new ArrayList<DimensionDescriptor>();
        this.initCRS(dimensions);
        this.initSpatialDomain();
        this.setDimensionDescriptors(dimensions);
        if (this.reader.ancillaryFileManager.isImposedSchema()) {
            this.updateDimensions(this.getDimensionDescriptors());
        }
    }

    private void updateDimensions(List<DimensionDescriptor> dimensionDescriptors) throws IOException {
        Map<Name, String> mapping = this.reader.ancillaryFileManager.variablesMap;
        Set<Name> keys = mapping.keySet();
        String varName = this.getName();
        for (Name key : keys) {
            String origName = mapping.get(key);
            if (!origName.equalsIgnoreCase(varName)) continue;
            String coverageName = key.getLocalPart();
            Indexer.Coverages.Coverage coverage = this.reader.ancillaryFileManager.coveragesMapping.get(coverageName);
            SchemaType schema = coverage.getSchema();
            if (schema == null) break;
            String schName = schema.getName();
            CoverageSlicesCatalog catalog = this.reader.getCatalog();
            if (catalog == null) break;
            SimpleFeatureType schemaType = null;
            try {
                if (schName != null) {
                    schemaType = catalog.getSchema(schName);
                }
            }
            catch (IOException e) {
                schemaType = catalog.getSchema(coverageName);
            }
            if (schemaType != null) {
                this.updateMapping(schemaType, dimensionDescriptors);
                break;
            }
            throw new IllegalStateException("Unable to find the table for this coverage: " + coverageName);
        }
    }

    public void updateMapping(SimpleFeatureType indexSchema, List<DimensionDescriptor> descriptors) throws IOException {
        String currentDimName;
        NetCDFGeoreferenceManager.DimensionMapper mapper = this.reader.georeferencing.getDimensionMapper();
        Set<String> dimensionNames = mapper.getDimensionNames();
        if (dimensionNames == null || dimensionNames.isEmpty() || descriptors == null || descriptors.isEmpty() || indexSchema.getAttributeCount() <= 2) {
            return;
        }
        int indexAttribute = 2;
        AttributeDescriptor attributeDescriptor = indexSchema.getDescriptor(indexAttribute);
        String updatedAttribute = attributeDescriptor.getLocalName();
        if ("location".equalsIgnoreCase(updatedAttribute)) {
            ++indexAttribute;
        }
        if (dimensionNames.contains(currentDimName = NetCDFUtilities.TIME_DIM) && this.remapAttribute(indexSchema, currentDimName, indexAttribute, descriptors, mapper)) {
            ++indexAttribute;
        }
        if (dimensionNames.contains(currentDimName = NetCDFUtilities.ELEVATION_DIM) && this.remapAttribute(indexSchema, currentDimName, indexAttribute, descriptors, mapper)) {
            ++indexAttribute;
        }
        if (this.getAdditionalDomains() != null) {
            for (CoverageSource.AdditionalDomain dom : this.getAdditionalDomains()) {
                currentDimName = dom.getName();
                if (!this.remapAttribute(indexSchema, currentDimName, indexAttribute, descriptors, mapper)) continue;
                ++indexAttribute;
            }
        }
    }

    private boolean remapAttribute(SimpleFeatureType indexSchema, String currentDimName, int indexAttribute, List<DimensionDescriptor> descriptors, NetCDFGeoreferenceManager.DimensionMapper mapper) {
        int numAttributes = indexSchema.getAttributeCount();
        if (numAttributes <= indexAttribute) {
            return false;
        }
        AttributeDescriptor attributeDescriptor = indexSchema.getDescriptor(indexAttribute);
        for (DimensionDescriptor descriptor : descriptors) {
            if (!descriptor.getName().toUpperCase().equalsIgnoreCase(currentDimName)) continue;
            String updatedAttribute = attributeDescriptor.getLocalName();
            if (!updatedAttribute.equals(descriptor.getStartAttribute())) {
                ((DefaultDimensionDescriptor)descriptor).setStartAttribute(updatedAttribute);
                mapper.remap(currentDimName, updatedAttribute);
            }
            return true;
        }
        return false;
    }

    private void initCRS(List<DimensionDescriptor> dimensions) throws IllegalArgumentException, RuntimeException, IOException, IllegalStateException {
        this.coordinateSystem = NetCDFCRSUtilities.getCoordinateSystem(this.variableDS);
        if (this.coordinateSystem == null) {
            throw new IllegalArgumentException("Provided CoordinateSystem is null");
        }
        this.coordinateSystem = new CoordinateSystemAdapter(this.coordinateSystem);
        ArrayList<Integer> nDimensionIndexList = new ArrayList<Integer>(2);
        nDimensionIndexList.add(-1);
        nDimensionIndexList.add(-1);
        int index = -1;
        ArrayList axesSorted = new ArrayList(this.coordinateSystem.getCoordinateAxes());
        Collections.sort(axesSorted, AXIS_COMPARATOR);
        block5: for (CoordinateAxis axis : axesSorted) {
            ++index;
            String fullName = axis.getFullName();
            if (NetCDFUtilities.getIgnoredDimensions().contains(fullName)) {
                this.ignoredDimensions.add(fullName);
                continue;
            }
            CoordinateVariable<?> cv = this.reader.georeferencing.getCoordinateVariable(axis.getShortName());
            if (cv == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to find a coordinate variable for " + fullName);
                }
                --index;
                continue;
            }
            switch (cv.getAxisType()) {
                case Time: {
                    this.initTemporalDomain(cv, dimensions);
                    nDimensionIndexList.set(1, index);
                    continue block5;
                }
                case GeoZ: 
                case Height: 
                case Pressure: {
                    String axisName = cv.getName();
                    if (NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(axisName)) {
                        this.initVerticalDomain(cv, dimensions);
                        nDimensionIndexList.set(0, index);
                        continue block5;
                    }
                    this.initAdditionalDomain(cv, dimensions);
                    nDimensionIndexList.add(index);
                    continue block5;
                }
                case GeoX: 
                case GeoY: 
                case Lat: 
                case Lon: {
                    continue block5;
                }
            }
            this.initAdditionalDomain(cv, dimensions);
            nDimensionIndexList.add(index);
        }
        this.nDimensionIndex = nDimensionIndexList.stream().mapToInt(i -> i).toArray();
        ReferencedEnvelope bbox = this.reader.georeferencing.getBoundingBox(this.variableDS.getShortName());
        this.coordinateReferenceSystem = bbox.getCoordinateReferenceSystem();
    }

    private void initVerticalDomain(CoordinateVariable<?> cv, List<DimensionDescriptor> dimensions) throws IOException {
        this.setHasVerticalDomain(true);
        UnidataVerticalDomain verticalDomain = new UnidataVerticalDomain(cv);
        this.setVerticalDomain(verticalDomain);
        dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor("ELEVATION", cv.getUnit(), CoverageUtilities.UCUM.ELEVATION_UNITS.getSymbol(), cv.getName(), null));
    }

    private void initTemporalDomain(CoordinateVariable<?> cv, List<DimensionDescriptor> dimensions) throws IOException {
        if (!cv.getType().equals(Date.class)) {
            throw new IllegalArgumentException("Unable to init temporal domain from CoordinateVariable that does not bind to Date");
        }
        if (!(cv.getCoordinateReferenceSystem() instanceof TemporalCRS)) {
            throw new IllegalArgumentException("Unable to init temporal domain from CoordinateVariable that does not have a TemporalCRS");
        }
        this.setHasTemporalDomain(true);
        UnidataTemporalDomain temporalDomain = new UnidataTemporalDomain(cv);
        this.setTemporalDomain(temporalDomain);
        String timeAttribute = this.reader.uniqueTimeAttribute ? "time" : cv.getName();
        dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor("TIME", CoverageUtilities.UCUM.TIME_UNITS.getName(), CoverageUtilities.UCUM.TIME_UNITS.getSymbol(), timeAttribute, null));
    }

    private void initAdditionalDomain(CoordinateVariable<?> cv, List<DimensionDescriptor> dimensions) throws IOException {
        try {
            UnidataAdditionalDomain domain = new UnidataAdditionalDomain(cv);
            if (this.getAdditionalDomains() == null) {
                this.setAdditionalDomains(new ArrayList<CoverageSource.AdditionalDomain>());
            }
            this.getAdditionalDomains().add(domain);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return;
        }
        if (cv.getType().equals(Date.class)) {
            if (!(cv.getCoordinateReferenceSystem() instanceof TemporalCRS)) {
                throw new IllegalArgumentException("Unable to init temporal domain from CoordinateVariable that does not have a TemporalCRS");
            }
            dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor(cv.getName(), CoverageUtilities.UCUM.TIME_UNITS.getName(), CoverageUtilities.UCUM.TIME_UNITS.getSymbol(), cv.getName(), null));
        } else if (Number.class.isAssignableFrom(cv.getType())) {
            dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor(cv.getName(), cv.getUnit(), cv.getUnit(), cv.getName(), null));
        } else {
            throw new IllegalArgumentException("Unable to init domain from CoordinateVariable of type: " + cv.getType().getName());
        }
        this.setHasAdditionalDomains(true);
    }

    private void initSpatialDomain() throws Exception {
        UnidataSpatialDomain spatialDomain = new UnidataSpatialDomain();
        this.setSpatialDomain(spatialDomain);
        ReferencedEnvelope bbox = this.reader.georeferencing.getBoundingBox(this.variableDS.getShortName());
        spatialDomain.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
        spatialDomain.setReferencedEnvelope(bbox);
        spatialDomain.setGridGeometry(this.getGridGeometry());
    }

    private void initRange() {
        Unit<?> unit;
        HashSet<SampleDimension> sampleDims;
        String description;
        Category[] categories;
        MultipleBandsDimensionInfo multipleBands;
        block13: {
            NumberRange validRange;
            this.width = this.variableDS.getDimension(this.variableDS.getRank() - 1).getLength();
            this.height = this.variableDS.getDimension(this.variableDS.getRank() - 2).getLength();
            String candidateDimension = ((Dimension)this.variableDS.getDimensions().get(0)).getFullName();
            multipleBands = this.reader.ancillaryFileManager.getMultipleBandsDimensionInfo(candidateDimension);
            if (multipleBands != null) {
                this.numBands = multipleBands.getNumberOfBands();
            } else {
                int n = this.numBands = this.variableDS.getRank() > 2 ? this.variableDS.getDimension(2).getLength() : 1;
            }
            if (this.reader.getImageMosaicRequest() != null) {
                int[] selectedBands = this.reader.getImageMosaicRequest().getBands();
                this.numBands = selectedBands == null ? this.numBands : selectedBands.length;
            }
            int bufferType = NetCDFUtilities.getRawDataType((VariableSimpleIF)this.variableDS);
            this.sampleModel = new BandedSampleModel(bufferType, this.width, this.height, multipleBands == null ? 1 : this.numBands);
            Number noData = NetCDFUtilities.getNodata((Variable)this.variableDS);
            ArrayList<Category> catArray = new ArrayList<Category>();
            Category noDataCategory = null;
            Category dataCategory = null;
            categories = null;
            if (noData != null) {
                NumberRange noDataRange = NumberRange.create((double)noData.doubleValue(), (boolean)true, (double)noData.doubleValue(), (boolean)true);
                noDataCategory = new Category((CharSequence)Category.NODATA.getName(), new Color[]{new Color(0, 0, 0, 0)}, noDataRange);
                catArray.add(noDataCategory);
            }
            if ((validRange = NetCDFUtilities.getRange((Variable)this.variableDS)) != null) {
                dataCategory = new Category((CharSequence)"RANGE", (Color)null, validRange);
                catArray.add(dataCategory);
            }
            categories = new Category[catArray.size()];
            categories = catArray.toArray(categories);
            description = this.variableDS.getDescription();
            if (description == null) {
                description = this.variableDS.getShortName();
            }
            sampleDims = new HashSet<SampleDimension>();
            unit = null;
            String unitString = this.variableDS.getUnitsString();
            if (StringUtils.isNotEmpty((CharSequence)unitString) && (unit = UNITS_CACHE.get(unitString)) == null) {
                try {
                    unit = NetCDFUnitFormat.getInstance().parse(unitString);
                    UNITS_CACHE.put(unitString, unit);
                }
                catch (MeasurementParseException parseException) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block13;
                    LOGGER.fine("Unable to parse the unit:" + unitString + "\nNo unit will be assigned");
                }
            }
        }
        if (multipleBands == null) {
            sampleDims.add((SampleDimension)new GridSampleDimension((CharSequence)description, categories, (Unit)unit));
        } else {
            for (String bandName : multipleBands.getBandsNamesInOrder()) {
                sampleDims.add((SampleDimension)new GridSampleDimension((CharSequence)bandName, categories, unit));
            }
        }
        SimpleInternationalString desc = null;
        if (description != null && !description.isEmpty()) {
            desc = new SimpleInternationalString(description);
        }
        DefaultFieldType fieldType = new DefaultFieldType((Name)new NameImpl(this.getName()), (InternationalString)desc, sampleDims);
        DefaultRangeType range = new DefaultRangeType(this.getName(), description, fieldType);
        this.setRangeType(range);
    }

    protected GridGeometry2D getGridGeometry() throws IOException {
        int[] low = new int[2];
        int[] high = new int[2];
        double[] origin = new double[2];
        double scaleX = Double.POSITIVE_INFINITY;
        double scaleY = Double.POSITIVE_INFINITY;
        block4: for (CoordinateVariable<?> cv : this.reader.georeferencing.getCoordinatesVariables(this.variableDS.getShortName())) {
            if (!cv.isNumeric()) continue;
            AxisType axisType = cv.getAxisType();
            switch (axisType) {
                case GeoX: 
                case Lon: {
                    double vv;
                    int k;
                    double v;
                    int j;
                    low[0] = 0;
                    high[0] = (int)cv.getSize();
                    if (cv.isRegular()) {
                        origin[0] = cv.getStart();
                        scaleX = cv.getIncrement();
                        break;
                    }
                    List<?> vals = cv.read();
                    double min = ((Number)cv.getMinimum()).doubleValue();
                    double max = ((Number)cv.getMaximum()).doubleValue();
                    if (!Double.isNaN(min) && !Double.isNaN(max)) {
                        origin[0] = min;
                        scaleX = (max - min) / (double)vals.size();
                        break;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Axis values contains NaN; finding first valid values");
                    }
                    for (j = 0; j < vals.size(); ++j) {
                        v = ((Number)vals.get(j)).doubleValue();
                        if (Double.isNaN(v)) continue;
                        for (k = vals.size(); k > j; --k) {
                            vv = ((Number)vals.get(k)).doubleValue();
                            if (Double.isNaN(vv)) continue;
                            origin[0] = v;
                            scaleX = (vv - v) / (double)vals.size();
                        }
                    }
                    continue block4;
                }
                case GeoY: 
                case Lat: {
                    double vv;
                    int k;
                    double v;
                    int j;
                    low[1] = 0;
                    high[1] = (int)cv.getSize();
                    if (cv.isRegular()) {
                        if (cv.getIncrement() > 0.0) {
                            scaleY = -cv.getIncrement();
                            origin[1] = cv.getStart() - scaleY * (double)(high[1] - 1);
                            break;
                        }
                        scaleY = cv.getIncrement();
                        origin[1] = cv.getStart();
                        break;
                    }
                    List<?> values = cv.read();
                    double min = ((Number)cv.getMinimum()).doubleValue();
                    double max = ((Number)cv.getMaximum()).doubleValue();
                    if (!Double.isNaN(min) && !Double.isNaN(max)) {
                        scaleY = -(max - min) / (double)values.size();
                        origin[1] = max;
                        break;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Axis values contains NaN; finding first valid values");
                    }
                    for (j = 0; j < values.size(); ++j) {
                        v = ((Number)values.get(j)).doubleValue();
                        if (Double.isNaN(v)) continue;
                        for (k = values.size(); k > j; --k) {
                            vv = ((Number)values.get(k)).doubleValue();
                            if (Double.isNaN(vv)) continue;
                            origin[1] = v;
                            scaleY = -(vv - v) / (double)values.size();
                        }
                    }
                    continue block4;
                }
            }
        }
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, origin[0], origin[1]);
        GridEnvelope2D gridRange = new GridEnvelope2D(low[0], low[1], high[0] - low[0], high[1] - low[1]);
        LinearTransform raster2Model = ProjectiveTransform.create((AffineTransform)at);
        return new GridGeometry2D((GridEnvelope)gridRange, PixelInCell.CELL_CENTER, (MathTransform)raster2Model, this.coordinateReferenceSystem, GeoTools.getDefaultHints());
    }

    public int getNumBands() {
        return this.numBands;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public VariableAdapter(NetCDFImageReader reader, Name coverageName, VariableDS variable) throws Exception {
        this.variableDS = variable;
        this.reader = reader;
        this.coverageName = coverageName;
        this.setName(variable.getFullName());
        this.init();
    }

    @Override
    public UnidataSpatialDomain getSpatialDomain() {
        return (UnidataSpatialDomain)super.getSpatialDomain();
    }

    @Override
    public UnidataTemporalDomain getTemporalDomain() {
        return (UnidataTemporalDomain)super.getTemporalDomain();
    }

    @Override
    public UnidataVerticalDomain getVerticalDomain() {
        return (UnidataVerticalDomain)super.getVerticalDomain();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNDimensionIndex(int n) {
        return this.nDimensionIndex[n];
    }

    public int getNIndex(int n, int imageIndex) {
        if (n < this.nDimensionIndex.length && this.nDimensionIndex[n] >= 0) {
            int factor = 1;
            for (int i = 0; i < n; ++i) {
                if (this.nDimensionIndex[i] < 0) continue;
                factor *= NetCDFUtilities.getDimensionLength((Variable)this.variableDS, this.nDimensionIndex[i]);
            }
            return imageIndex % (NetCDFUtilities.getDimensionLength((Variable)this.variableDS, this.nDimensionIndex[n]) * factor) / factor;
        }
        return -1;
    }

    public int[] splitIndex(int imageIndex) {
        int[] resultIndex = new int[this.nDimensionIndex.length];
        for (int n = 0; n < this.nDimensionIndex.length; ++n) {
            resultIndex[n] = this.getNIndex(n, imageIndex);
        }
        return resultIndex;
    }

    public Map<String, Integer> mapIndex(int[] splittedIndex) {
        HashMap<String, Integer> resultIndex = new HashMap<String, Integer>();
        for (int n = 0; n < splittedIndex.length; ++n) {
            if (this.nDimensionIndex[n] == -1) continue;
            resultIndex.put(this.variableDS.getDimension(this.nDimensionIndex[n]).getFullName(), splittedIndex[n]);
        }
        return resultIndex;
    }

    public int getNumberOfSlices() {
        return QUICK_SCAN ? 1 : this.numberOfSlices;
    }

    public int[] getShape() {
        return this.variableDS.getShape();
    }

    public int getFeatures(int startIndex, int limit, ListFeatureCollection collection) {
        SimpleFeatureType indexSchema = collection.getSchema();
        int slicesNum = this.getNumberOfSlices();
        if (startIndex > slicesNum) {
            throw new IllegalArgumentException("The paging start index can't be higher than the number of available slices");
        }
        int lastIndex = startIndex + limit;
        if (lastIndex > slicesNum) {
            lastIndex = slicesNum;
        }
        String varName = this.variableDS.getFullName();
        for (int imageIndex = startIndex; imageIndex < lastIndex; ++imageIndex) {
            int[] index = this.splitIndex(imageIndex);
            Slice2DIndex variableIndex = new Slice2DIndex(index, varName);
            this.reader.ancillaryFileManager.addSlice(variableIndex);
            SimpleFeature feature = this.createFeature(this.coverageName.toString(), index, this.coordinateSystem, imageIndex, indexSchema);
            if (feature == null) continue;
            collection.add(feature);
        }
        return lastIndex - startIndex;
    }

    private SimpleFeature createFeature(String coverageName, int[] index, CoordinateSystem cs, int imageIndex, SimpleFeatureType indexSchema) {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)indexSchema);
        feature.setAttribute("the_geom", (Object)NetCDFCRSUtilities.GEOM_FACTORY.toGeometry((Envelope)this.reader.georeferencing.getBoundingBox(this.variableDS.getShortName())));
        feature.setAttribute("imageindex", (Object)imageIndex);
        Map<String, Integer> mappedIndex = this.mapIndex(index);
        if (this.nDimensionIndex[1] >= 0) {
            Date date = (Date)this.getValueByIndex(this.nDimensionIndex[1], mappedIndex);
            if (date == null) {
                return null;
            }
            this.setFeatureTime(feature, date, cs);
        }
        if (this.nDimensionIndex[0] >= 0) {
            Number verticalValue = (Number)this.getValueByIndex(this.nDimensionIndex[0], mappedIndex);
            if (verticalValue == null) {
                return null;
            }
            feature.setAttribute(this.reader.georeferencing.getDimensionMapper().getDimension(NetCDFUtilities.ELEVATION_DIM), (Object)verticalValue);
        }
        if (this.getAdditionalDomains() != null) {
            for (int i = 0; i < this.getAdditionalDomains().size(); ++i) {
                CoverageSource.AdditionalDomain domain = this.getAdditionalDomains().get(i);
                Object value = domain.getType().equals((Object)CoverageSource.DomainType.DATE) ? this.getValueByIndex(this.nDimensionIndex[i + 2], mappedIndex) : this.getValueByIndex(this.nDimensionIndex[i + 2], mappedIndex);
                if (value == null) {
                    return null;
                }
                feature.setAttribute(this.reader.georeferencing.getDimensionMapper().getDimension(domain.getName().toUpperCase()), value);
            }
        }
        return feature;
    }

    private String setFeatureTime(SimpleFeature feature, Date date, CoordinateSystem cs) {
        String originalTimeAttribute = null;
        if (date != null) {
            String timeAttribute = originalTimeAttribute = this.getTimeAttribute(cs);
            if (this.reader.uniqueTimeAttribute) {
                timeAttribute = "time";
            }
            feature.setAttribute(timeAttribute, (Object)date);
        }
        return originalTimeAttribute;
    }

    private String getTimeAttribute(CoordinateSystem cs) {
        CoordinateAxis timeAxis = cs.getTaxis();
        String name = timeAxis != null ? timeAxis.getFullName() : NetCDFUtilities.TIME_DIM;
        NetCDFGeoreferenceManager.DimensionMapper dimensionMapper = this.reader.georeferencing.getDimensionMapper();
        String timeAttribute = dimensionMapper.getDimension(name.toUpperCase());
        if (timeAttribute == null) {
            timeAttribute = dimensionMapper.getDimension(NetCDFUtilities.TIME_DIM);
        }
        return timeAttribute;
    }

    private <T> T getValueByIndex(int dimensionIndex, Map<String, Integer> mappedIndex) {
        Dimension dimension = this.variableDS.getDimension(dimensionIndex);
        return (T)this.reader.georeferencing.getCoordinateVariable(dimension.getFullName()).read(mappedIndex);
    }

    public static void clearCache() {
        UNITS_CACHE.clear();
    }

    static {
        AXIS_COMPARATOR = new CoordinateAxis.AxisComparator();
        UNITS_CACHE = new SoftValueHashMap();
        QUICK_SCAN = Boolean.getBoolean(QUICK_SCAN_KEY);
        UNIT_CHARS_REPLACEMENTS = new HashSet<UnitCharReplacement>();
        UNIT_CHARS_REPLACEMENTS.add(new UnitCharReplacement("-", "^-"));
        UNIT_CHARS_REPLACEMENTS.add(new UnitCharReplacement(".", "*"));
        UNIT_CHARS_REPLACEMENTS.add(new UnitCharReplacement("1/s", "s^-1"));
        LOGGER = Logging.getLogger(VariableAdapter.class);
    }

    static class CoordinateSystemAdapter
    extends CoordinateSystem {
        private CoordinateSystem cs;
        private final boolean vertical;

        CoordinateSystemAdapter(CoordinateSystem cs) {
            this.cs = cs;
            if (cs.hasVerticalAxis()) {
                this.vertical = true;
            } else {
                Set<String> unsupported = NetCDFUtilities.getUnsupportedDimensions();
                boolean present = false;
                for (String dimension : unsupported) {
                    if (!cs.containsAxis(dimension)) continue;
                    present = true;
                    break;
                }
                this.vertical = present;
            }
        }

        public boolean hasVerticalAxis() {
            return this.vertical;
        }

        public boolean hasTimeAxis() {
            return this.cs.hasTimeAxis();
        }

        public CoordinateAxis getTaxis() {
            return this.cs.getTaxis();
        }

        public ImmutableList<CoordinateAxis> getCoordinateAxes() {
            return this.cs.getCoordinateAxes();
        }
    }

    public class UnidataAdditionalDomain
    extends CoverageSource.AdditionalDomain {
        private final Set<Object> domainExtent = new TreeSet<Object>();
        private final Set<Object> globalDomainExtent = new TreeSet<Object>(new Comparator<Object>(){
            private NumberRangeComparator numberRangeComparator = new NumberRangeComparator();
            private DateRangeComparator dateRangeComparator = new DateRangeComparator();

            @Override
            public int compare(Object o1, Object o2) {
                boolean o1IsDateRange = true;
                boolean o2IsDateRange = true;
                if (o1 instanceof NumberRange) {
                    o1IsDateRange = false;
                } else if (!(o1 instanceof DateRange)) {
                    throw new ClassCastException(o1.getClass() + " is not an known range type");
                }
                if (o2 instanceof NumberRange) {
                    o2IsDateRange = false;
                } else if (!(o2 instanceof DateRange)) {
                    throw new ClassCastException(o2.getClass() + " is not an known range type");
                }
                if (o1IsDateRange && o2IsDateRange) {
                    return this.dateRangeComparator.compare((DateRange)o1, (DateRange)o2);
                }
                if (!o1IsDateRange && !o2IsDateRange) {
                    return this.numberRangeComparator.compare((Range<? extends Number>)((NumberRange)o1), (Range<? extends Number>)((NumberRange)o2));
                }
                throw new ClassCastException("Incompatible range types: " + o1.getClass() + " is not the same as " + o2.getClass());
            }
        });
        private final String name;
        private final CoverageSource.DomainType type;
        final CoordinateVariable<?> adaptee;

        UnidataAdditionalDomain(CoordinateVariable<?> adaptee) throws IOException {
            this.adaptee = adaptee;
            this.name = adaptee.getName();
            Class<?> type = adaptee.getType();
            if (Date.class.isAssignableFrom(type)) {
                this.type = CoverageSource.DomainType.DATE;
                this.globalDomainExtent.add(new DateRange((Date)adaptee.getMinimum(), (Date)adaptee.getMaximum()));
            } else if (Number.class.isAssignableFrom(type)) {
                this.type = CoverageSource.DomainType.NUMBER;
                this.globalDomainExtent.add(new NumberRange(Double.class, (Number)((Number)adaptee.getMinimum()).doubleValue(), (Number)((Number)adaptee.getMaximum()).doubleValue()));
            } else {
                throw new UnsupportedOperationException("Unsupported CoordinateVariable:" + adaptee.toString());
            }
            this.domainExtent.addAll(adaptee.read());
        }

        @Override
        public Set<Object> getElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                return this.globalDomainExtent;
            }
            return this.domainExtent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CoverageSource.DomainType getType() {
            return this.type;
        }

        public Set<Object> getDomainExtent() {
            return this.domainExtent;
        }
    }

    public class UnidataVerticalDomain
    extends CoverageSource.VerticalDomain {
        final CoordinateVariable<? extends Number> adaptee;

        UnidataVerticalDomain(CoordinateVariable<?> cv) {
            if (!Number.class.isAssignableFrom(cv.getType())) {
                throw new IllegalArgumentException("Unable to wrap a non Number CoordinateVariable:" + cv.toString());
            }
            CoordinateVariable<?> cast = cv;
            this.adaptee = cast;
        }

        public SortedSet<NumberRange<Double>> getVerticalExtent() {
            NumberRange global;
            CoordinateVariable<? extends Number> verticalDimension = this.adaptee;
            try {
                global = NumberRange.create((double)verticalDimension.getMinimum().doubleValue(), (double)verticalDimension.getMaximum().doubleValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DoubleRangeTreeSet globalVerticalExtent = new DoubleRangeTreeSet();
            globalVerticalExtent.add(global);
            return globalVerticalExtent;
        }

        @Override
        public SortedSet<? extends NumberRange<Double>> getVerticalElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                TreeSet<Range<? extends Number>> extent = new TreeSet<Range<? extends Number>>(new NumberRangeComparator());
                for (Number number : this.adaptee.read()) {
                    double doubleValue = number.doubleValue();
                    extent.add((Range<? extends Number>)NumberRange.create((double)doubleValue, (double)doubleValue));
                }
                return extent;
            }
            return this.getVerticalExtent();
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.adaptee.getCoordinateReferenceSystem();
        }
    }

    public class UnidataTemporalDomain
    extends CoverageSource.TemporalDomain {
        final CoordinateVariable<Date> adaptee;

        UnidataTemporalDomain(CoordinateVariable<?> adaptee) {
            if (!Date.class.isAssignableFrom(adaptee.getType())) {
                throw new IllegalArgumentException("Unable to wrap non temporal CoordinateVariable:" + adaptee.toString());
            }
            CoordinateVariable<?> cast = adaptee;
            this.adaptee = cast;
        }

        public SortedSet<DateRange> getTemporalExtent() {
            try {
                Date startTime = this.adaptee.getMinimum();
                Date endTime = this.adaptee.getMaximum();
                DateRange global = new DateRange(startTime, endTime);
                DateRangeTreeSet globalTemporalExtent = new DateRangeTreeSet();
                globalTemporalExtent.add(global);
                return globalTemporalExtent;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SortedSet<? extends DateRange> getTemporalElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                TreeSet<DateRange> extent = new TreeSet<DateRange>(new DateRangeComparator());
                for (Date dd : this.adaptee.read()) {
                    extent.add(new DateRange(dd, dd));
                }
                return extent;
            }
            return this.getTemporalExtent();
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.adaptee.getCoordinateReferenceSystem();
        }
    }

    public class UnidataSpatialDomain
    extends CoverageSource.SpatialDomain {
        private CoordinateReferenceSystem coordinateReferenceSystem;
        private ReferencedEnvelope referencedEnvelope;
        private GridGeometry2D gridGeometry;

        public ReferencedEnvelope getReferencedEnvelope() {
            return this.referencedEnvelope;
        }

        public void setReferencedEnvelope(ReferencedEnvelope referencedEnvelope) {
            this.referencedEnvelope = referencedEnvelope;
        }

        public GridGeometry2D getGridGeometry() {
            return this.gridGeometry;
        }

        public double[] getFullResolution() {
            AffineTransform gridToCRS = (AffineTransform)this.gridGeometry.getGridToCRS();
            return CoverageUtilities.getResolution((AffineTransform)gridToCRS);
        }

        public void setGridGeometry(GridGeometry2D gridGeometry) {
            this.gridGeometry = gridGeometry;
        }

        public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
            this.coordinateReferenceSystem = coordinateReferenceSystem;
        }

        @Override
        public Set<? extends BoundingBox> getSpatialElements(boolean overall, ProgressListener listener) throws IOException {
            return Collections.singleton(this.referencedEnvelope);
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
            return this.coordinateReferenceSystem;
        }

        @Override
        public MathTransform2D getGridToWorldTransform(ProgressListener listener) throws IOException {
            return this.gridGeometry.getGridToCRS2D(PixelOrientation.CENTER);
        }

        @Override
        public Set<? extends RasterLayout> getRasterElements(boolean overall, ProgressListener listener) throws IOException {
            Rectangle bounds = this.gridGeometry.getGridRange2D().getBounds();
            return Collections.singleton(new RasterLayout(bounds));
        }
    }

    static class UnitCharReplacement {
        String from;
        String to;

        public UnitCharReplacement(String from, String to) {
            this.from = from;
            this.to = to;
        }

        String replace(String input) {
            if (input != null && input.contains(this.from)) {
                return input.replace(this.from, this.to);
            }
            return input;
        }
    }
}

