/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wmts;

import java.io.IOException;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.ServicesUtils;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.io.XMLBuilder;
import org.geowebcache.service.wmts.WMTSExtensionImpl;
import org.xml.sax.Attributes;

public class WMTSExtendedCapabilitiesProvider
extends WMTSExtensionImpl {
    public static final String VS_VS_OWS_NAMESPACE = "http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0";
    public static final String VS_VS_OWS_SCHEMA = "http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0/inspire_vs_ows_11.xsd";
    private final GeoServer geoserver;

    public WMTSExtendedCapabilitiesProvider(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public String[] getSchemaLocations() {
        return new String[]{VS_VS_OWS_NAMESPACE, VS_VS_OWS_SCHEMA};
    }

    public void registerNamespaces(XMLBuilder xml) throws IOException {
        xml.attribute("xmlns:inspire_vs", VS_VS_OWS_NAMESPACE);
        xml.attribute("xmlns:inspire_common", "http://inspire.ec.europa.eu/schemas/common/1.0");
    }

    public void encodedOperationsMetadata(final XMLBuilder xml) throws IOException {
        ExtendedCapabilitiesProvider.Translator translator = new ExtendedCapabilitiesProvider.Translator(){

            public void start(String element) {
                try {
                    xml.indentElement(element);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public void start(String element, Attributes attributes) {
                try {
                    xml.indentElement(element);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        xml.attribute(attributes.getQName(i), attributes.getValue(i));
                    }
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public void chars(String text) {
                try {
                    xml.text(text);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public void end(String element) {
                try {
                    xml.endElement(element);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
        MetadataMap serviceMetadata = ((WMTSInfo)this.geoserver.getService(WMTSInfo.class)).getMetadata();
        Boolean createExtendedCapabilities = (Boolean)serviceMetadata.get(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, Boolean.class);
        String metadataURL = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_URL.key));
        if (metadataURL == null || createExtendedCapabilities != null && !createExtendedCapabilities.booleanValue()) {
            return;
        }
        String mediaType = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_TYPE.key));
        ServicesUtils.addScenario1Elements(translator, metadataURL, mediaType, serviceMetadata);
    }

    public ServiceInformation getServiceInformation() {
        return new ServiceInformation();
    }
}

