/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.inspire.web.LanguageDropDownChoice;

public class LanguagesEditor
extends FormComponentPanel<String> {
    ListMultipleChoice<String> languages;
    DropDownChoice<String> langChoice;

    public LanguagesEditor(String id, IModel<String> model) {
        super(id, model);
        String strLanguages = (String)model.getObject();
        List<Object> langList = strLanguages != null ? Arrays.asList(strLanguages.split(",")) : new ArrayList();
        this.languages = new ListMultipleChoice("languages", (IModel)new Model(), langList);
        this.languages.setOutputMarkupId(true);
        this.add(new Component[]{this.languages});
        this.langChoice = new LanguageDropDownChoice("selectLanguage", (IModel<String>)new Model());
        this.langChoice.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer<String>(){

            public String getIdValue(String object, int index) {
                return object;
            }
        });
        this.langChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.langChoice});
        this.add(new Component[]{this.addButton()});
        this.add(new Component[]{this.removeButton()});
    }

    private AjaxButton addButton() {
        AjaxButton button = new AjaxButton("addLanguage"){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                String value = LanguagesEditor.this.langChoice.getInput();
                LanguagesEditor.this.langChoice.setModelObject(null);
                LanguagesEditor.this.langChoice.modelChanged();
                List languagesList = LanguagesEditor.this.languages.getChoices();
                ArrayList<String> newList = new ArrayList<String>(languagesList);
                newList.removeIf(l -> l.contains(value) || value.contains((CharSequence)l));
                newList.add(value);
                LanguagesEditor.this.languages.setChoices(newList);
                LanguagesEditor.this.languages.modelChanged();
                target.add(new Component[]{LanguagesEditor.this.langChoice, LanguagesEditor.this.languages});
            }
        };
        button.setDefaultFormProcessing(false);
        return button;
    }

    private AjaxButton removeButton() {
        AjaxButton button = new AjaxButton("removeLanguages"){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                Collection selection = (Collection)LanguagesEditor.this.languages.getModelObject();
                ArrayList languagesList = new ArrayList(LanguagesEditor.this.languages.getChoices());
                for (String selected : selection) {
                    languagesList.remove(selected);
                }
                LanguagesEditor.this.languages.setChoices(languagesList);
                LanguagesEditor.this.languages.modelChanged();
                target.add(new Component[]{LanguagesEditor.this.languages});
            }
        };
        return button;
    }

    public void convertInput() {
        super.convertInput();
        List list = this.languages.getChoices();
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        for (String l : list) {
            sb.append(l);
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        super.setConvertedInput((Object)sb.toString());
    }
}

