/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.inspire.web.LanguageDropDownChoice;
import org.geoserver.inspire.web.LanguagesEditor;
import org.geoserver.inspire.web.UniqueResourceIdentifiersEditor;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.web.services.AdminPagePanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.util.MetadataMapModel;
import org.geoserver.wfs.WFSInfo;

public class InspireAdminPanel
extends AdminPagePanel {
    private static final long serialVersionUID = -7670555379263411393L;

    public InspireAdminPanel(String id, IModel<ServiceInfo> model) {
        super(id, model);
        MetadataMap serviceMetadata = ((ServiceInfo)model.getObject()).getMetadata();
        String metadataURL = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_URL.key));
        boolean isDownloadService = model.getObject() instanceof WFSInfo || model.getObject() instanceof WCSInfo;
        UniqueResourceIdentifiers ids = null;
        if (isDownloadService) {
            ids = (UniqueResourceIdentifiers)serviceMetadata.get(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, UniqueResourceIdentifiers.class);
        }
        if (!serviceMetadata.containsKey((Object)InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key)) {
            if (metadataURL == null || isDownloadService && (ids == null || ids.isEmpty())) {
                serviceMetadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
            } else {
                serviceMetadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
            }
        }
        PropertyModel metadata = new PropertyModel(model, "metadata");
        final CheckBox createInspireExtendedCapabilities = new CheckBox("createExtendedCapabilities", (IModel)new MetadataMapModel((IModel)metadata, InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, Boolean.class));
        this.add(new Component[]{createInspireExtendedCapabilities});
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final WebMarkupContainer configs = new WebMarkupContainer("configs");
        configs.setOutputMarkupId(true);
        configs.setVisible(((Boolean)createInspireExtendedCapabilities.getModelObject()).booleanValue());
        container.add(new Component[]{configs});
        createInspireExtendedCapabilities.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                configs.setVisible(((Boolean)createInspireExtendedCapabilities.getModelObject()).booleanValue());
                target.add(new Component[]{container});
            }
        }});
        if (!((ServiceInfo)model.getObject()).getMetadata().containsKey((Object)InspireMetadata.LANGUAGE.key)) {
            ((ServiceInfo)model.getObject()).getMetadata().put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"eng"));
        }
        configs.add(new Component[]{new LanguageDropDownChoice("language", (IModel<String>)new MapModel((IModel)metadata, InspireMetadata.LANGUAGE.key))});
        configs.add(new Component[]{new LanguagesEditor("otherLanguages", (IModel<String>)new MapModel((IModel)metadata, InspireMetadata.OTHER_LANGUAGES.key))});
        TextField metadataUrlField = new TextField("metadataURL", (IModel)new MapModel((IModel)metadata, InspireMetadata.SERVICE_METADATA_URL.key));
        metadataUrlField.setRequired(true);
        FormComponentFeedbackBorder metadataURLBorder = new FormComponentFeedbackBorder("border");
        metadataURLBorder.add(new Component[]{metadataUrlField});
        configs.add(new Component[]{metadataURLBorder});
        metadataUrlField.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("InspireAdminPanel.metadataURL.title"))});
        HashMap<String, String> mdUrlTypes = new HashMap<String, String>();
        mdUrlTypes.put("application/vnd.ogc.csw.GetRecordByIdResponse_xml", "CSW GetRecordById Response");
        mdUrlTypes.put("application/vnd.iso.19139+xml", "ISO 19139 ServiceMetadata record");
        MapModel urlTypeModel = new MapModel((IModel)metadata, InspireMetadata.SERVICE_METADATA_TYPE.key);
        ChoiceRenderer<String> urlTypeChoiceRenderer = new ChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(String key) {
                String resourceKey = "InspireAdminPanel.metadataURLType." + key;
                String defaultValue = key;
                String displayValue = new ResourceModel(resourceKey, defaultValue).getObject();
                return displayValue;
            }

            public String getIdValue(String key, int index) {
                return key;
            }
        };
        ArrayList urlTypeChoices = new ArrayList(mdUrlTypes.keySet());
        DropDownChoice serviceMetadataRecordType = new DropDownChoice("metadataURLType", (IModel)urlTypeModel, urlTypeChoices, (IChoiceRenderer)urlTypeChoiceRenderer);
        serviceMetadataRecordType.setNullValid(true);
        configs.add(new Component[]{serviceMetadataRecordType});
        WebMarkupContainer identifiersContainer = new WebMarkupContainer("datasetIdentifiersContainer");
        identifiersContainer.setVisible(isDownloadService);
        configs.add(new Component[]{identifiersContainer});
        MetadataMapModel sdiModel = new MetadataMapModel((IModel)metadata, InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, UniqueResourceIdentifiers.class);
        UniqueResourceIdentifiersEditor identifiersEditor = new UniqueResourceIdentifiersEditor("spatialDatasetIdentifiers", (IModel<UniqueResourceIdentifiers>)sdiModel);
        identifiersContainer.add(new Component[]{identifiersEditor});
    }
}

