/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wcs;

import java.io.IOException;
import java.util.List;
import net.opengis.wcs20.GetCapabilitiesType;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.ServicesUtils;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.wcs.WCSInfo;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class WCSExtendedCapabilitiesProvider
extends org.geoserver.wcs2_0.response.WCSExtendedCapabilitiesProvider {
    public String[] getSchemaLocations(String schemaBaseURL) {
        return new String[]{"http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "https://inspire.ec.europa.eu/schemas/inspire_dls/1.0/inspire_dls.xsd"};
    }

    public void registerNamespaces(NamespaceSupport namespaces) {
        namespaces.declarePrefix("inspire_common", "http://inspire.ec.europa.eu/schemas/common/1.0");
        namespaces.declarePrefix("inspire_dls", "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0");
    }

    public void encodeExtendedOperations(ExtendedCapabilitiesProvider.Translator tx, WCSInfo wcs, GetCapabilitiesType request) throws IOException {
    }

    public void encodeExtendedContents(ExtendedCapabilitiesProvider.Translator tx, WCSInfo wcs, List<CoverageInfo> coverages, GetCapabilitiesType request) throws IOException {
        MetadataMap serviceMetadata = wcs.getMetadata();
        Boolean createExtendedCapabilities = (Boolean)serviceMetadata.get(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, Boolean.class);
        String metadataURL = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_URL.key));
        String mediaType = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_TYPE.key));
        UniqueResourceIdentifiers ids = (UniqueResourceIdentifiers)serviceMetadata.get(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, UniqueResourceIdentifiers.class);
        if (metadataURL == null || ids == null || ids.isEmpty() || createExtendedCapabilities != null && !createExtendedCapabilities.booleanValue()) {
            return;
        }
        tx.start("ows:ExtendedCapabilities");
        tx.start("inspire_dls:ExtendedCapabilities");
        tx.start("inspire_common:MetadataUrl");
        tx.start("inspire_common:URL");
        tx.chars(metadataURL);
        tx.end("inspire_common:URL");
        if (mediaType != null) {
            tx.start("inspire_common:MediaType");
            tx.chars(mediaType);
            tx.end("inspire_common:MediaType");
        }
        tx.end("inspire_common:MetadataUrl");
        ServicesUtils.encodeSupportedLanguages(serviceMetadata, tx);
        for (UniqueResourceIdentifier id : ids) {
            if (id.getMetadataURL() != null) {
                tx.start("inspire_dls:SpatialDataSetIdentifier", this.atts("metadataURL", id.getMetadataURL()));
            } else {
                tx.start("inspire_dls:SpatialDataSetIdentifier");
            }
            tx.start("inspire_common:Code");
            tx.chars(id.getCode());
            tx.end("inspire_common:Code");
            if (id.getNamespace() != null) {
                tx.start("inspire_common:Namespace");
                tx.chars(id.getNamespace());
                tx.end("inspire_common:Namespace");
            }
            tx.end("inspire_dls:SpatialDataSetIdentifier");
        }
        tx.end("inspire_dls:ExtendedCapabilities");
        tx.end("ows:ExtendedCapabilities");
    }

    Attributes atts(String ... atts) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < atts.length; i += 2) {
            attributes.addAttribute(null, atts[i], atts[i], null, atts[i + 1]);
        }
        return attributes;
    }
}

