/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.inspire.InspireDirectoryManager;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.xml.sax.helpers.NamespaceSupport;

public final class ServicesUtils {
    private ServicesUtils() {
    }

    public static void registerNameSpaces(NamespaceSupport namespaces) {
        namespaces.declarePrefix("inspire_vs", "http://inspire.ec.europa.eu/schemas/inspire_vs/1.0");
        namespaces.declarePrefix("inspire_common", "http://inspire.ec.europa.eu/schemas/common/1.0");
    }

    public static void addScenario1Elements(ExtendedCapabilitiesProvider.Translator translator, String metadataUrl, String mediaType, MetadataMap metadataMap) {
        translator.start("inspire_vs:ExtendedCapabilities");
        translator.start("inspire_common:MetadataUrl");
        translator.start("inspire_common:URL");
        translator.chars(metadataUrl);
        translator.end("inspire_common:URL");
        if (mediaType != null) {
            translator.start("inspire_common:MediaType");
            translator.chars(mediaType);
            translator.end("inspire_common:MediaType");
        }
        translator.end("inspire_common:MetadataUrl");
        ServicesUtils.encodeSupportedLanguages(metadataMap, translator);
        translator.end("inspire_vs:ExtendedCapabilities");
    }

    public static void encodeSupportedLanguages(MetadataMap metadataMap, ExtendedCapabilitiesProvider.Translator translator) {
        String defaultLanguage = null;
        if (metadataMap.get((Object)InspireMetadata.LANGUAGE.key) != null) {
            defaultLanguage = metadataMap.get((Object)InspireMetadata.LANGUAGE.key).toString();
        }
        String otherLanguages = null;
        if (metadataMap.get((Object)InspireMetadata.OTHER_LANGUAGES.key) != null) {
            otherLanguages = metadataMap.get((Object)InspireMetadata.OTHER_LANGUAGES.key).toString();
        }
        List<String> langList = otherLanguages == null ? null : Arrays.asList(otherLanguages.split(","));
        translator.start("inspire_common:SupportedLanguages");
        translator.start("inspire_common:DefaultLanguage");
        translator.start("inspire_common:Language");
        translator.chars(defaultLanguage);
        translator.end("inspire_common:Language");
        translator.end("inspire_common:DefaultLanguage");
        if (langList != null) {
            for (String lang : langList) {
                if (lang.equals(defaultLanguage) || lang.equals("")) continue;
                translator.start("inspire_common:SupportedLanguage");
                translator.start("inspire_common:Language");
                translator.chars(lang);
                translator.end("inspire_common:Language");
                translator.end("inspire_common:SupportedLanguage");
            }
        }
        translator.end("inspire_common:SupportedLanguages");
        translator.start("inspire_common:ResponseLanguage");
        translator.start("inspire_common:Language");
        translator.chars(ServicesUtils.retrieveLanguageParameter(defaultLanguage, langList));
        translator.end("inspire_common:Language");
        translator.end("inspire_common:ResponseLanguage");
    }

    private static String retrieveLanguageParameter(String defaultLanguage, List<String> languages) {
        Map kvpDispatcher = ((Request)Dispatcher.REQUEST.get()).getRawKvp();
        String value = null;
        if (kvpDispatcher != null && kvpDispatcher.containsKey("LANGUAGE")) {
            Object reqLang = kvpDispatcher.get("LANGUAGE");
            value = ServicesUtils.getIfSupported(reqLang, languages);
        }
        if (value == null || value.isEmpty()) {
            value = defaultLanguage;
        }
        return value;
    }

    private static String getIfSupported(Object reqLang, List<String> inspireLangs) {
        String inspireLang;
        String value = null;
        if (reqLang != null && inspireLangs.contains(inspireLang = ServicesUtils.mapToInspireLanguage(reqLang.toString()))) {
            value = inspireLang;
        }
        return value;
    }

    private static String mapToInspireLanguage(String lang) {
        try {
            Properties props = InspireDirectoryManager.get().getLanguagesMappings();
            String result = lang;
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                if (!entry.getValue().equals(lang)) continue;
                result = key;
                break;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

