/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.awt.Color;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Stroke;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.GraphicBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.styling.StrokeImpl;
import org.geotools.util.Converters;

public class StrokeBuilder
extends AbstractStyleBuilder<Stroke> {
    Expression color;
    Expression width;
    Expression opacity;
    Expression lineCap;
    Expression lineJoin;
    float[] dashArray = null;
    List<Expression> dashArrayExpressions = null;
    Expression dashOffset;
    GraphicBuilder graphicFill = new GraphicBuilder(this).unset();
    GraphicBuilder graphicStroke = new GraphicBuilder(this).unset();

    public StrokeBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public StrokeBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    @Override
    public StrokeBuilder unset() {
        return (StrokeBuilder)super.unset();
    }

    public StrokeBuilder reset() {
        this.color = StrokeImpl.DEFAULT.getColor();
        this.width = StrokeImpl.DEFAULT.getWidth();
        this.opacity = StrokeImpl.DEFAULT.getOpacity();
        this.lineCap = StrokeImpl.DEFAULT.getLineCap();
        this.lineJoin = StrokeImpl.DEFAULT.getLineJoin();
        this.dashArray = StrokeImpl.DEFAULT.getDashArray();
        this.dashArrayExpressions = StrokeImpl.DEFAULT.dashArray();
        this.dashOffset = StrokeImpl.DEFAULT.getDashOffset();
        this.graphicFill.unset();
        this.graphicStroke.unset();
        this.unset = false;
        return this;
    }

    public StrokeBuilder reset(Stroke stroke) {
        if (stroke == null) {
            return this.unset();
        }
        this.color = stroke.getColor();
        this.width = stroke.getWidth();
        this.opacity = stroke.getOpacity();
        this.lineCap = stroke.getLineCap();
        this.lineJoin = stroke.getLineJoin();
        this.dashArray = stroke.getDashArray();
        this.dashArrayExpressions = stroke.dashArray();
        this.dashOffset = stroke.getDashOffset();
        this.graphicFill.reset(stroke.getGraphicFill());
        this.graphicStroke.reset(stroke.getGraphicStroke());
        this.unset = false;
        return this;
    }

    public StrokeBuilder color(Expression color) {
        this.unset = false;
        this.color = color;
        return this;
    }

    public StrokeBuilder color(Color color) {
        return this.color(this.literal(color));
    }

    public StrokeBuilder color(String cqlExpression) {
        return this.color(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder colorHex(String hex) {
        Color color = (Color)Converters.convert((Object)hex, Color.class);
        if (color == null) {
            throw new IllegalArgumentException("The provided expression could not be turned into a color: " + hex);
        }
        return this.color(color);
    }

    public StrokeBuilder width(Expression width) {
        this.unset = false;
        this.width = width;
        return this;
    }

    public StrokeBuilder width(double width) {
        return this.width(this.literal(width));
    }

    public StrokeBuilder width(String cqlExpression) {
        return this.width(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder opacity(Expression opacity) {
        this.unset = false;
        this.opacity = opacity;
        return this;
    }

    public StrokeBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public StrokeBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineCap(Expression lineCap) {
        this.unset = false;
        this.lineCap = lineCap;
        return this;
    }

    public StrokeBuilder lineCap(String cqlExpression) {
        return this.lineCap(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineCapName(String cap) {
        return this.lineCap(this.literal(cap));
    }

    public StrokeBuilder lineJoin(Expression lineJoin) {
        this.unset = false;
        this.lineJoin = lineJoin;
        return this;
    }

    public StrokeBuilder lineJoin(String cqlExpression) {
        return this.lineJoin(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineJoinName(String join) {
        return this.lineJoin(this.literal(join));
    }

    public StrokeBuilder dashArray(float ... dashArray) {
        this.dashArray = dashArray;
        this.unset = false;
        return this;
    }

    public StrokeBuilder dashArray(List<Expression> dashArrayExpressions) {
        this.dashArrayExpressions = dashArrayExpressions;
        return this;
    }

    public StrokeBuilder dashOffset(Expression dashOffset) {
        this.dashOffset = dashOffset;
        return this;
    }

    public StrokeBuilder dashOffset(double dashOffset) {
        return this.dashOffset(this.literal(dashOffset));
    }

    public StrokeBuilder dashOffset(String cqlExpression) {
        return this.dashOffset(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder graphicStroke() {
        this.unset = false;
        return this.graphicStroke;
    }

    public GraphicBuilder fillBuilder() {
        this.unset = false;
        return this.graphicFill;
    }

    @Override
    public Stroke build() {
        if (this.unset) {
            return null;
        }
        Stroke stroke = this.sf.createStroke(this.color, this.width, this.opacity, this.lineJoin, this.lineCap, this.dashArray, this.dashOffset, this.graphicFill.build(), this.graphicStroke.build());
        if (this.dashArrayExpressions != null && !this.dashArrayExpressions.isEmpty()) {
            stroke.setDashArray(this.dashArrayExpressions);
        }
        if (this.parent == null) {
            this.reset();
        }
        return stroke;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().line().stroke().init(this);
    }
}

