/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.LinePlacement;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.TextSymbolizerBuilder;

public class LinePlacementBuilder
extends AbstractStyleBuilder<LinePlacement> {
    private Expression offset;
    private Expression initialGap;
    private Expression gap;
    private boolean repeated;
    private boolean generalizedLine;
    private boolean aligned;

    public LinePlacementBuilder() {
        this((TextSymbolizerBuilder)null);
    }

    public LinePlacementBuilder offset(double offset) {
        this.offset = this.literal(offset);
        return this;
    }

    public LinePlacementBuilder offset(Expression offset) {
        this.offset = offset;
        return this;
    }

    public LinePlacementBuilder gap(double gap) {
        this.gap = this.literal(gap);
        return this;
    }

    public LinePlacementBuilder gap(Expression gap) {
        this.gap = gap;
        return this;
    }

    public LinePlacementBuilder repeated(boolean repeated) {
        this.repeated = repeated;
        return this;
    }

    public LinePlacementBuilder generalizedLine(boolean generalizedLine) {
        this.generalizedLine = generalizedLine;
        return this;
    }

    public LinePlacementBuilder aligned(boolean aligned) {
        this.aligned = aligned;
        return this;
    }

    LinePlacementBuilder(TextSymbolizerBuilder parent) {
        super(parent);
        this.reset();
    }

    @Override
    public LinePlacement build() {
        if (this.unset) {
            return null;
        }
        LinePlacement linePlacement = this.sf.linePlacement(this.offset, this.initialGap, this.gap, this.repeated, this.aligned, this.generalizedLine);
        if (this.parent == null) {
            this.reset();
        }
        return linePlacement;
    }

    public LinePlacementBuilder reset() {
        this.aligned = false;
        this.generalizedLine = false;
        this.repeated = false;
        this.gap = this.literal(0);
        this.initialGap = this.literal(0);
        this.offset = this.literal(0);
        this.unset = false;
        return this;
    }

    public LinePlacementBuilder reset(LinePlacement placement) {
        if (placement == null) {
            return this.reset();
        }
        this.aligned = placement.isAligned();
        this.generalizedLine = placement.isGeneralizeLine();
        this.repeated = placement.isRepeated();
        this.gap = placement.getGap();
        this.initialGap = placement.getInitialGap();
        this.offset = placement.getPerpendicularOffset();
        this.unset = false;
        return this;
    }

    @Override
    public LinePlacementBuilder unset() {
        return (LinePlacementBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().text().labelText("label").linePlacement().init(this);
    }
}

