/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.CssRuleComparator;
import org.geotools.styling.css.RulesCombiner;
import org.geotools.styling.css.selector.Accept;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.util.FilteredPowerSetBuilder;
import org.geotools.styling.css.util.PseudoClassRemover;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;
import org.geotools.util.logging.Logging;

class RulePowerSetBuilder
extends FilteredPowerSetBuilder<CssRule, CssRule> {
    static final Logger LOGGER = Logging.getLogger(RulePowerSetBuilder.class);
    RulesCombiner combiner;
    int maxCombinations = -1;
    int count = 0;
    UnboundSimplifyingFilterVisitor simplifier;
    List<CssRule> mixins;

    private static List[] classifyRules(List<CssRule> domain) {
        ArrayList<CssRule> main = new ArrayList<CssRule>();
        ArrayList<CssRule> mixins = new ArrayList<CssRule>();
        for (CssRule rule : domain) {
            if (rule.getProperties().get(PseudoClass.ROOT) == null) {
                Selector simplified = (Selector)rule.selector.accept(new PseudoClassRemover());
                rule = new CssRule(simplified, rule.properties, rule.comment);
                mixins.add(rule);
                continue;
            }
            main.add(rule);
        }
        Collections.sort(main, CssRuleComparator.ASCENDING);
        Collections.sort(mixins, CssRuleComparator.ASCENDING);
        return new List[]{main, mixins};
    }

    public RulePowerSetBuilder(List<CssRule> domain, UnboundSimplifyingFilterVisitor simplifier) {
        this(RulePowerSetBuilder.classifyRules(domain), simplifier, -1);
    }

    RulePowerSetBuilder(List<CssRule> domain, UnboundSimplifyingFilterVisitor simplifier, int maxCombinations) {
        this(RulePowerSetBuilder.classifyRules(domain), simplifier, maxCombinations);
    }

    protected RulePowerSetBuilder(List[] domainMixins, UnboundSimplifyingFilterVisitor simplifier, int maxCombinations) {
        super(domainMixins[0]);
        this.mixins = domainMixins[1];
        this.maxCombinations = maxCombinations;
        this.simplifier = simplifier;
        this.combiner = new RulesCombiner(simplifier);
    }

    @Override
    protected List<CssRule> buildResult(List<CssRule> rules) {
        boolean foundSymbolizerProperty = false;
        for (CssRule rule : rules) {
            if (!rule.hasSymbolizerProperty()) continue;
            foundSymbolizerProperty = true;
            break;
        }
        if (!foundSymbolizerProperty) {
            return null;
        }
        CssRule combined = rules.size() == 1 ? rules.get(0) : this.combiner.combineRules(rules);
        ArrayList<CssRule> results = new ArrayList<CssRule>();
        if (this.mixins == null || this.mixins.isEmpty()) {
            results.add(combined);
        } else {
            List<CssRule> applicableMixins = this.getApplicableMixins(combined);
            if (!applicableMixins.isEmpty()) {
                int idx;
                for (idx = 0; idx < applicableMixins.size(); ++idx) {
                    CssRule mixin = applicableMixins.get(idx);
                    Selector mixedSelector = Selector.and(mixin.selector, combined.selector, (Object)this.simplifier);
                    if (mixedSelector == Selector.REJECT) continue;
                    if (!mixedSelector.equals(combined.selector)) break;
                    combined = this.combiner.combineRules(Arrays.asList(combined, mixin));
                }
                if (idx < applicableMixins.size()) {
                    ArrayList<CssRule> list = new ArrayList<CssRule>();
                    list.add(combined);
                    list.addAll(applicableMixins.subList(idx, applicableMixins.size()));
                    RulePowerSetBuilder builder = new RulePowerSetBuilder(new List[]{list, Collections.emptyList()}, this.simplifier, this.maxCombinations - this.count);
                    List conditionalPowerSet = builder.buildPowerSet();
                    results.addAll(conditionalPowerSet);
                } else {
                    results.add(combined);
                }
            } else {
                results.add(combined);
            }
        }
        this.count += results.size();
        if (this.maxCombinations > 0 && this.count > this.maxCombinations) {
            LOGGER.severe("Bailing out, the CSS rule combinations have already generated more than maxCombinations SLD rules, giving up. Please simplify your CSS style");
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("New rule (" + this.count + "):" + combined);
        }
        return results;
    }

    private List<CssRule> getApplicableMixins(CssRule rule) {
        Set<PseudoClass> mixablePseudoClasses = rule.getMixablePseudoClasses();
        ArrayList<CssRule> result = new ArrayList<CssRule>();
        for (CssRule mixin : this.mixins) {
            Set<PseudoClass> pseudoClasses = mixin.properties.keySet();
            boolean found = false;
            for (PseudoClass pseudoClass : pseudoClasses) {
                if (!mixablePseudoClasses.contains(pseudoClass)) continue;
                found = true;
                break;
            }
            if (!found || !this.acceptMixinCssRule(rule, mixin)) continue;
            result.add(mixin);
        }
        return result;
    }

    protected boolean acceptMixinCssRule(CssRule rule, CssRule mixinRule) {
        return true;
    }

    @Override
    protected boolean accept(List<CssRule> rules) {
        if (this.count > this.maxCombinations) {
            return false;
        }
        Selector combined = this.combiner.combineSelectors(rules);
        return combined != Selector.REJECT;
    }

    @Override
    protected List<CssRule> postFilterResult(List<CssRule> result) {
        ArrayList<CssRule> filtered = new ArrayList<CssRule>();
        for (CssRule cssRule : result) {
            if (cssRule.getProperties().get(PseudoClass.ROOT) == null) continue;
            filtered.add(cssRule);
        }
        if (filtered.size() <= 1) {
            return filtered;
        }
        Collections.sort(filtered, CssRuleComparator.DESCENDING);
        return filtered;
    }

    @Override
    protected boolean isInclude(CssRule t) {
        return t.getSelector() instanceof Accept;
    }
}

