/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.matchers.SequenceMatcher;

public class StringMatcher
extends SequenceMatcher {
    public final char[] characters;

    public StringMatcher(Rule[] ruleArray, char[] cArray) {
        super(Preconditions.checkArgNotNull(ruleArray, "charMatchers"));
        this.characters = cArray;
    }

    @Override
    public String getLabel() {
        return super.getLabel() != null ? super.getLabel() : "\"" + String.valueOf(this.characters) + "\"";
    }

    @Override
    public boolean hasCustomLabel() {
        return true;
    }

    @Override
    public boolean match(MatcherContext matcherContext) {
        if (!matcherContext.fastStringMatching()) {
            return super.match(matcherContext);
        }
        if (!matcherContext.getInputBuffer().test(matcherContext.getCurrentIndex(), this.characters)) {
            return false;
        }
        matcherContext.advanceIndex(this.characters.length);
        matcherContext.createNode();
        return true;
    }
}

