/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;

public class TransverseMercator
extends MapProjection {
    private static final double EPSILON = 1.0E-6;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private final double esp;
    private final double ml0;
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;

    protected TransverseMercator(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        this.esp = this.excentricitySquared / (1.0 - this.excentricitySquared);
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinphi = Math.sin(y);
        double cosphi = Math.cos(y);
        double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
        t *= t;
        double al = cosphi * x;
        double als = al * al;
        double n = this.esp * cosphi * cosphi;
        double ys1 = 1385.0 + t * (t * (543.0 - t) - 3111.0);
        double ys2 = 61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * ys1;
        double ys3 = 5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * ys2;
        y = this.mlfn(y, sinphi, cosphi) - this.ml0 + sinphi * (al /= Math.sqrt(1.0 - this.excentricitySquared * sinphi * sinphi)) * x * 0.5 * (1.0 + 0.08333333333333333 * als * ys3);
        double xs1 = 61.0 + t * (t * (179.0 - t) - 479.0);
        double xs2 = 5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * xs1;
        x = al * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * xs2));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi = this.inv_mlfn(this.ml0 + y);
        if (Math.abs(phi) >= 1.5707963267948966) {
            y = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            x = 0.0;
        } else {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
            double n = this.esp * cosphi * cosphi;
            double con = 1.0 - this.excentricitySquared * sinphi * sinphi;
            double d = x * Math.sqrt(con);
            con *= t;
            t *= t;
            double ds = d * d;
            double ys1 = 1385.0 + t * (3633.0 + t * (4095.0 + 1575.0 * t));
            double ys2 = 61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * ys1;
            double ys3 = 5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * ys2;
            y = phi - con * ds / (1.0 - this.excentricitySquared) * 0.5 * (1.0 - ds * 0.08333333333333333 * ys3);
            double xs1 = 61.0 + t * (662.0 + t * (1320.0 + 720.0 * t));
            double xs2 = 5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * xs1;
            x = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * xs2)) / cosphi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected double getToleranceForAssertions(double longitude, double latitude) {
        double longitudeDifference = Math.abs(longitude - this.centralMeridian);
        if (longitudeDifference > 0.26) {
            return 2.5;
        }
        if (longitudeDifference > 0.22) {
            return 1.0;
        }
        if (longitudeDifference > 0.17) {
            return 0.5;
        }
        if (Math.abs(latitude - this.latitudeOfOrigin) < 1.0E-5) {
            return 0.01;
        }
        return super.getToleranceForAssertions(longitude, latitude);
    }

    private int getZone(double centralLongitudeZone1, double zoneWidth) {
        double zoneCount = Math.abs(360.0 / zoneWidth);
        double t = centralLongitudeZone1 - 0.5 * zoneWidth;
        t = Math.toDegrees(this.centralMeridian) - t;
        t = Math.floor(t / zoneWidth + 1.0E-6);
        t -= zoneCount * Math.floor(t / zoneCount);
        return (int)t + 1;
    }

    private double getCentralMedirian(double centralLongitudeZone1, double zoneWidth) {
        double t = centralLongitudeZone1 + (double)(this.getZone(centralLongitudeZone1, zoneWidth) - 1) * zoneWidth;
        t -= 360.0 * Math.floor((t + 180.0) / 360.0);
        return t;
    }

    public int getZone() {
        if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
            return this.getZone(-177.0, 6.0);
        }
        if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
            return this.getZone(-52.5, -3.0);
        }
        throw new IllegalStateException("Unknow projection type.");
    }

    public double getCentralMeridian() {
        if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
            return this.getCentralMedirian(-177.0, 6.0);
        }
        if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
            return this.getCentralMedirian(-52.5, -3.0);
        }
        throw new IllegalStateException("Unknow projection type.");
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.ml0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransverseMercator that = (TransverseMercator)o;
        return TransverseMercator.equals(that.esp, this.esp) && TransverseMercator.equals(that.ml0, this.ml0);
    }

    public static class Provider_SouthOrientated
    extends Provider {
        public Provider_SouthOrientated() {
            super(Provider_SouthOrientated.createDescriptorGroup(new NamedIdentifier(Citations.EPSG, "Transverse Mercator (South Orientated)"), new NamedIdentifier(Citations.EPSG, "9808"), new NamedIdentifier(Citations.PROJ, "tmerc")));
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            MapProjection projection = (MapProjection)super.createMathTransform(parameters);
            if (projection.falseEasting == 0.0 && projection.falseNorthing == 0.0) {
                return projection;
            }
            AffineTransform step = AffineTransform.getTranslateInstance(-2.0 * projection.falseEasting, -2.0 * projection.falseNorthing);
            return ConcatenatedTransform.create(ProjectiveTransform.create(step), projection);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier(Citations.OGC, "Transverse_Mercator"), new NamedIdentifier(Citations.EPSG, "Transverse Mercator"), new NamedIdentifier(Citations.EPSG, "Gauss-Kruger"), new NamedIdentifier(Citations.EPSG, "9807"), new NamedIdentifier(Citations.GEOTIFF, "CT_TransverseMercator"), new NamedIdentifier(Citations.ESRI, "Transverse_Mercator"), new NamedIdentifier(Citations.ESRI, "Gauss_Kruger"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)225)), new NamedIdentifier(Citations.PROJ, "tmerc"));

        static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier ... identifiers) {
            return Provider.createDescriptorGroup(identifiers, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});
        }

        public Provider() {
            super(PARAMETERS);
        }

        Provider(ParameterDescriptorGroup descriptor) {
            super(descriptor);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new TransverseMercator(parameters);
        }
    }

    private static final class Spherical
    extends TransverseMercator {
        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.ensureSpherical();
        }

        @Override
        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double normalizedLongitude = x;
            assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
            double cosphi = Math.cos(y);
            double b = cosphi * Math.sin(x);
            if (Math.abs(Math.abs(b) - 1.0) <= 1.0E-6) {
                throw new ProjectionException("Numerical value tend toward infinity.");
            }
            y = Math.atan2(Math.tan(y), Math.cos(x)) - this.latitudeOfOrigin;
            x = 0.5 * Math.log((1.0 + b) / (1.0 - b));
            assert (Spherical.checkTransform(x, y, ptDst, this.getToleranceForSphereAssertions(normalizedLongitude)));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double sinhX = Math.sinh(x);
            double cosD = Math.cos(this.latitudeOfOrigin + y);
            double phi = Math.asin(Math.sqrt((1.0 - cosD * cosD) / (1.0 + sinhX * sinhX)));
            y = y + this.latitudeOfOrigin < 0.0 ? -phi : phi;
            double d = x = Math.abs(sinhX) <= 1.0E-6 && Math.abs(cosD) <= 1.0E-6 ? 0.0 : Math.atan2(sinhX, cosD);
            assert (Spherical.checkInverseTransform(x, y, ptDst, this.getToleranceForSphereAssertions(x)));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected double getToleranceForSphereAssertions(double longitude) {
            if (Math.abs(Math.abs(longitude) - 1.5707963267948966) < 1.0E-10) {
                return 1.0E18;
            }
            if (Math.abs(longitude) > 0.26) {
                return 1000000.0;
            }
            return 1.0E-6;
        }
    }
}

