/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.PlanarProjection;
import org.geotools.measure.Latitude;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class EquidistantConic
extends MapProjection {
    private static final long serialVersionUID = 5885522933843653157L;
    private static final double EPSILON = 1.0E-6;
    private final double rho0;
    private final double n;
    private final double c;
    private final double phi1;
    private double phi2;

    protected EquidistantConic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        boolean secant;
        double n;
        List expected = this.getParameterDescriptors().descriptors();
        this.phi1 = this.doubleValue(expected, Provider.STANDARD_PARALLEL_1, parameters);
        EquidistantConic.ensureLatitudeInRange(Provider.STANDARD_PARALLEL_1, this.phi1, true);
        this.phi2 = this.doubleValue(expected, Provider.STANDARD_PARALLEL_2, parameters);
        if (Double.isNaN(this.phi2)) {
            this.phi2 = this.phi1;
        }
        EquidistantConic.ensureLatitudeInRange(Provider.STANDARD_PARALLEL_2, this.phi2, true);
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-6) {
            Latitude arg0 = new Latitude(Math.toDegrees(this.phi1));
            Latitude arg1 = new Latitude(Math.toDegrees(this.phi2));
            throw new IllegalArgumentException(MessageFormat.format("Latitudes {0} and {1} are opposite.", arg0, arg1));
        }
        double sinphi = n = Math.sin(this.phi1);
        double cosphi = Math.cos(this.phi1);
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) >= 1.0E-6;
        if (this.isSpherical) {
            if (secant) {
                n = (cosphi - Math.cos(this.phi2)) / (this.phi2 - this.phi1);
            }
            this.c = this.phi1 + Math.cos(this.phi1) / n;
            this.rho0 = this.c - this.latitudeOfOrigin;
            this.en4 = 0.0;
            this.en3 = 0.0;
            this.en2 = 0.0;
            this.en1 = 0.0;
            this.en0 = 0.0;
        } else {
            double m1 = this.msfn(sinphi, cosphi);
            double ml1 = this.mlfn(this.phi1, sinphi, cosphi);
            if (secant) {
                sinphi = Math.sin(this.phi2);
                cosphi = Math.cos(this.phi2);
                n = (m1 - this.msfn(sinphi, cosphi)) / (this.mlfn(this.phi2, sinphi, cosphi) - ml1);
            }
            this.c = ml1 + m1 / n;
            this.rho0 = this.c - this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
        }
        this.n = n;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        this.set(expected, Provider.STANDARD_PARALLEL_1, values, this.phi1);
        this.set(expected, Provider.STANDARD_PARALLEL_2, values, this.phi2);
        return values;
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double cosphi = Math.cos(y);
        double sinphi = Math.sin(y);
        double rho = this.c - (this.isSpherical ? y : this.mlfn(y, sinphi, cosphi));
        double x1 = rho * Math.sin(x *= this.n);
        double y1 = this.rho0 - rho * Math.cos(x);
        if (ptDst != null) {
            ptDst.setLocation(x1, y1);
            return ptDst;
        }
        return new Point2D.Double(x1, y1);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lam;
        double phi;
        double rho = Math.hypot(x, y = this.rho0 - y);
        if (rho != 0.0) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            phi = this.c - rho;
            if (!this.isSpherical) {
                phi = this.inv_mlfn(phi);
            }
            lam = Math.atan2(x, y) / this.n;
        } else {
            lam = 0.0;
            double d = phi = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(lam, phi);
            return ptDst;
        }
        return new Point2D.Double(lam, phi);
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 1995516958029802849L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTIFF, "CT_Equidistant_Conic"), new NamedIdentifier(Citations.ESRI, "Equidistant_Conic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)250)), new NamedIdentifier(Citations.PROJ, "eqdc")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<PlanarProjection> getOperationType() {
            return PlanarProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            return new EquidistantConic(parameters);
        }
    }
}

