/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.jdbc.JDBCUserGroupService;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.PasswordValidatorImpl;

public class JDBCUserGroupStore
extends JDBCUserGroupService
implements GeoServerUserGroupStore {
    protected boolean modified;
    protected Connection connection;
    protected JDBCUserGroupService jdbcService;

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = super.getConnection();
        }
        return this.connection;
    }

    @Override
    protected void closeConnection(Connection con) throws SQLException {
    }

    protected void releaseConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.jdbcService = (JDBCUserGroupService)service;
        this.setSecurityManager(service.getSecurityManager());
        this.name = this.jdbcService.getName();
        this.passwordEncoderName = service.getPasswordEncoderName();
        this.passwordValidatorName = service.getPasswordValidatorName();
        this.datasource = this.jdbcService.datasource;
        this.ddlProps = this.jdbcService.ddlProps;
        this.dmlProps = this.jdbcService.dmlProps;
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new IOException();
        }
    }

    @Override
    public void load() throws IOException {
        try {
            this.getConnection().rollback();
            this.releaseConnection();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserProperties(GeoServerUser user, Connection con) throws SQLException, IOException {
        if (user.getProperties().isEmpty()) {
            return;
        }
        PreparedStatement ps = this.getDMLStatement("userprops.insert", con);
        try {
            for (Object key : user.getProperties().keySet()) {
                Object propertyVal = user.getProperties().get(key);
                ps.setString(1, user.getUsername());
                ps.setString(2, key.toString());
                ps.setObject(3, propertyVal);
                ps.execute();
            }
        }
        finally {
            this.closeFinally(null, ps, null);
        }
    }

    protected void preparePassword(GeoServerUser user) throws IOException, PasswordPolicyException {
        char[] passwordArray;
        char[] cArray = passwordArray = user.getPassword() != null ? user.getPassword().toCharArray() : null;
        if (PasswordValidatorImpl.passwordStartsWithEncoderPrefix((char[])passwordArray) != null) {
            return;
        }
        this.getSecurityManager().loadPasswordValidator(this.getPasswordValidatorName()).validatePassword(passwordArray);
        GeoServerPasswordEncoder enc = this.getSecurityManager().loadPasswordEncoder(this.getPasswordEncoderName());
        enc.initializeFor((GeoServerUserGroupService)this);
        user.setPassword(enc.encodePassword(user.getPassword(), null));
    }

    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.preparePassword(user);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.insert", con);
            ps.setString(1, user.getUsername());
            if (user.getPassword() != null) {
                ps.setString(2, user.getPassword());
            } else {
                ps.setNull(2, 12);
            }
            ps.setString(3, this.convertToString(user.isEnabled()));
            ps.execute();
            this.addUserProperties(user, con);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.preparePassword(user);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.update", con);
            ps.setString(1, user.getPassword());
            ps.setString(2, this.convertToString(user.isEnabled()));
            ps.setString(3, user.getUsername());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("userprops.deleteForUser", con);
            ps.setString(1, user.getUsername());
            ps.execute();
            this.addUserProperties(user, con);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public boolean removeUser(GeoServerUser user) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        boolean retval = false;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.delete", con);
            ps.setString(1, user.getUsername());
            ps.execute();
            retval = ps.getUpdateCount() > 0;
            ps.close();
            ps = this.getDMLStatement("userprops.deleteForUser", con);
            ps.setString(1, user.getUsername());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("groupmembers.deleteUser", con);
            ps.setString(1, user.getUsername());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
        return retval;
    }

    public void addGroup(GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.insert", con);
            ps.setString(1, group.getGroupname());
            ps.setString(2, this.convertToString(group.isEnabled()));
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void updateGroup(GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.update", con);
            ps.setString(1, this.convertToString(group.isEnabled()));
            ps.setString(2, group.getGroupname());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        boolean retval = false;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.delete", con);
            ps.setString(1, group.getGroupname());
            ps.execute();
            retval = ps.getUpdateCount() > 0;
            ps.close();
            ps = this.getDMLStatement("groupmembers.deleteGroup", con);
            ps.setString(1, group.getGroupname());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
        return retval;
    }

    public void store() throws IOException {
        try {
            this.getConnection().commit();
            this.releaseConnection();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        this.setModified(false);
    }

    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groupmembers.insert", con);
            ps.setString(1, group.getGroupname());
            ps.setString(2, user.getUsername());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groupmembers.delete", con);
            ps.setString(1, group.getGroupname());
            ps.setString(2, user.getUsername());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void clear() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groupmembers.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("groups.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("userprops.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("users.deleteAll", con);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        return this.jdbcService.createUserObject(username, password, isEnabled);
    }
}

