/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.Util;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCRoleStore;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;

public class JDBCRoleService
extends AbstractJDBCService
implements GeoServerRoleService {
    static final String DEFAULT_DML_FILE = "rolesdml.xml";
    static final String DEFAULT_DDL_FILE = "rolesddl.xml";
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    protected String adminRoleName;
    protected String groupAdminRoleName;

    public GeoServerRole getAdminRole() {
        if (!StringUtils.hasLength((String)this.adminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRole getGroupAdminRole() {
        if (!StringUtils.hasLength((String)this.groupAdminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canCreateStore() {
        return true;
    }

    public GeoServerRoleStore createStore() throws IOException {
        JDBCRoleStore store = new JDBCRoleStore();
        store.initializeFromService(this);
        return store;
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.name = config.getName();
        this.initializeDSFromConfig(config);
        if (config instanceof JDBCSecurityServiceConfig) {
            JDBCSecurityServiceConfig jdbcConfig = (JDBCSecurityServiceConfig)config;
            String fileNameDML = jdbcConfig.getPropertyFileNameDML();
            Resource file = this.checkORCreateJDBCPropertyFile(fileNameDML, this.getConfigRoot(), DEFAULT_DML_FILE);
            this.dmlProps = Util.loadUniversal((InputStream)file.in());
            String fileNameDDL = jdbcConfig.getPropertyFileNameDDL();
            if (fileNameDDL != null && !fileNameDDL.isEmpty()) {
                file = this.checkORCreateJDBCPropertyFile(fileNameDDL, this.getConfigRoot(), DEFAULT_DDL_FILE);
                this.ddlProps = Util.loadUniversal((InputStream)file.in());
                this.createTablesIfRequired((JDBCSecurityServiceConfig)config);
            }
        }
        this.adminRoleName = ((SecurityRoleServiceConfig)config).getAdminRoleName();
        this.groupAdminRoleName = ((SecurityRoleServiceConfig)config).getGroupAdminRoleName();
    }

    @Override
    protected String[] getOrderedNamesForCreate() {
        return new String[]{"roles.create", "roleprops.create", "userroles.create", "userroles.indexcreate", "grouproles.create", "grouproles.indexcreate"};
    }

    @Override
    protected String[] getOrderedNamesForDrop() {
        return new String[]{"grouproles.drop", "userroles.drop", "roleprops.drop", "roles.drop"};
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        GeoServerRole roleObject = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.keyed", con);
            ps.setString(1, role);
            rs = ps.executeQuery();
            if (rs.next()) {
                roleObject = this.createRoleObject(role);
                ps2 = this.getDMLStatement("roleprops.selectForRole", con);
                ps2.setString(1, role);
                rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    String propName = rs2.getString(1);
                    Object propValue = rs2.getObject(2);
                    if (propName == null) continue;
                    roleObject.getProperties().put(propName, propValue == null ? "" : propValue);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        return roleObject;
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, GeoServerRole> map = new HashMap<String, GeoServerRole>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String rolename = rs.getString(1);
                GeoServerRole roleObject = this.createRoleObject(rolename);
                map.put(rolename, roleObject);
            }
            ps.close();
            rs.close();
            ps = this.getDMLStatement("roleprops.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String roleName = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                GeoServerRole roleObject = (GeoServerRole)map.get(roleName);
                if (roleObject == null) continue;
                roleObject.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet roles = new TreeSet();
        roles.addAll(map.values());
        return Collections.unmodifiableSortedSet(roles);
    }

    public Map<String, String> getParentMappings() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String rolename = rs.getString(1);
                String parentname = rs.getString(2);
                map.put(rolename, parentname);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return Collections.unmodifiableMap(map);
    }

    public GeoServerRole createRoleObject(String role) {
        return new GeoServerRole(role);
    }

    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        HashMap<String, GeoServerRole> map = new HashMap<String, GeoServerRole>();
        try {
            String rolename;
            con = this.getConnection();
            ps = this.getDMLStatement("userroles.rolesForUser", con);
            ps.setString(1, username);
            rs = ps.executeQuery();
            while (rs.next()) {
                rolename = rs.getString(1);
                GeoServerRole roleObject = this.createRoleObject(rolename);
                map.put(rolename, roleObject);
            }
            rs.close();
            ps.close();
            ps = this.getDMLStatement("roleprops.selectForUser", con);
            ps.setString(1, username);
            rs = ps.executeQuery();
            while (rs.next()) {
                rolename = rs.getString(1);
                String propName = rs.getString(2);
                Object propValue = rs.getObject(3);
                GeoServerRole roleObject = (GeoServerRole)map.get(rolename);
                if (roleObject == null) continue;
                roleObject.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        TreeSet roles = new TreeSet();
        roles.addAll(map.values());
        return Collections.unmodifiableSortedSet(roles);
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        HashMap<String, GeoServerRole> map = new HashMap<String, GeoServerRole>();
        try {
            String rolename;
            con = this.getConnection();
            ps = this.getDMLStatement("grouproles.rolesForGroup", con);
            ps.setString(1, groupname);
            rs = ps.executeQuery();
            while (rs.next()) {
                rolename = rs.getString(1);
                GeoServerRole roleObject = this.createRoleObject(rolename);
                map.put(rolename, roleObject);
            }
            rs.close();
            ps.close();
            ps = this.getDMLStatement("roleprops.selectForGroup", con);
            ps.setString(1, groupname);
            rs = ps.executeQuery();
            while (rs.next()) {
                rolename = rs.getString(1);
                String propName = rs.getString(2);
                Object propValue = rs.getObject(3);
                GeoServerRole roleObject = (GeoServerRole)map.get(rolename);
                if (roleObject == null) continue;
                roleObject.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        TreeSet roles = new TreeSet();
        roles.addAll(map.values());
        return Collections.unmodifiableSortedSet(roles);
    }

    public void load() throws IOException {
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        GeoServerRole roleObject = null;
        try {
            String parent;
            con = this.getConnection();
            ps = this.getDMLStatement("roles.keyed", con);
            ps.setString(1, role.getAuthority());
            rs = ps.executeQuery();
            if (rs.next() && (parent = rs.getString(1)) != null) {
                roleObject = this.createRoleObject(parent);
                ps2 = this.getDMLStatement("roleprops.selectForRole", con);
                ps2.setString(1, parent);
                rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    String propName = rs2.getString(1);
                    Object propValue = rs2.getObject(2);
                    roleObject.getProperties().put(propName, propValue == null ? "" : propValue);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        return roleObject;
    }

    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireRoleChangedEvent() {
        RoleLoadedEvent event = new RoleLoadedEvent((GeoServerRoleService)this);
        for (RoleLoadedListener listener : this.listeners) {
            listener.rolesChanged(event);
        }
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        TreeSet<String> result = new TreeSet<String>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("grouproles.groupsForRole", con);
            ps.setString(1, role.getAuthority());
            rs = ps.executeQuery();
            while (rs.next()) {
                String groupname = rs.getString(1);
                result.add(groupname);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return Collections.unmodifiableSortedSet(result);
    }

    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        TreeSet<String> result = new TreeSet<String>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userroles.usersForRole", con);
            ps.setString(1, role.getAuthority());
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                result.add(username);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return Collections.unmodifiableSortedSet(result);
    }

    public int getRoleCount() throws IOException {
        int count;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.count", con);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("Count query did not return any record");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }

    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        Properties props = new Properties();
        boolean personalized = false;
        for (Object key : roleParams.keySet()) {
            if (userProps.containsKey(key)) {
                props.put(key, userProps.get(key));
                personalized = true;
                continue;
            }
            props.put(key, roleParams.get(key));
        }
        return personalized ? props : null;
    }

    public Resource getConfigRoot() throws IOException {
        return this.getSecurityManager().get("security/role").get(this.getName());
    }
}

