/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.security.web.role.RuleRolesFormComponent;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.filter.Filter;

public abstract class AbstractDataAccessRulePage
extends AbstractSecurityPage {
    static List<AccessMode> MODES = Arrays.asList(AccessMode.READ, AccessMode.WRITE, AccessMode.ADMIN);
    DropDownChoice<String> rootChoice;
    DropDownChoice<String> layerChoice;
    DropDownChoice<AccessMode> accessModeChoice;
    RuleRolesFormComponent rolesFormComponent;
    CheckBox globalGroupRule;
    WebMarkupContainer layerContainer;
    Label rootLabel;
    WebMarkupContainer layerAndLabel;

    public AbstractDataAccessRulePage(DataAccessRule rule) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)rule));
        this.add(new Component[]{form});
        form.add((IFormValidator)new EmptyRolesValidator());
        Component[] componentArray = new Component[1];
        this.globalGroupRule = new CheckBox("globalGroupRule");
        componentArray[0] = this.globalGroupRule;
        form.add(componentArray);
        this.globalGroupRule.setOutputMarkupId(true);
        this.globalGroupRule.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractDataAccessRulePage.this.rootChoice.getModel().detach();
                target.add(new Component[]{AbstractDataAccessRulePage.this.rootChoice});
                AbstractDataAccessRulePage.this.layerAndLabel.setVisible((Boolean)AbstractDataAccessRulePage.this.globalGroupRule.getModelObject() == false);
                target.add(new Component[]{AbstractDataAccessRulePage.this.layerContainer});
                AbstractDataAccessRulePage.this.rootLabel.getDefaultModel().detach();
                target.add(new Component[]{AbstractDataAccessRulePage.this.rootLabel});
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.rootLabel = new Label("rootLabel", (IModel)new RootLabelModel());
        componentArray2[0] = this.rootLabel;
        form.add(componentArray2);
        this.rootLabel.setOutputMarkupId(true);
        Component[] componentArray3 = new Component[1];
        this.rootChoice = new DropDownChoice("root", (IModel)new RootsModel());
        componentArray3[0] = this.rootChoice;
        form.add(componentArray3);
        this.rootChoice.setRequired(true);
        this.rootChoice.setOutputMarkupId(true);
        this.rootChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractDataAccessRulePage.this.layerChoice.setChoices((IModel)new Model(AbstractDataAccessRulePage.this.getLayerNames((String)AbstractDataAccessRulePage.this.rootChoice.getConvertedInput())));
                AbstractDataAccessRulePage.this.layerChoice.modelChanged();
                target.add(new Component[]{AbstractDataAccessRulePage.this.layerChoice});
            }
        }});
        Component[] componentArray4 = new Component[1];
        this.layerContainer = new WebMarkupContainer("layerContainer");
        componentArray4[0] = this.layerContainer;
        form.add(componentArray4);
        this.layerContainer.setOutputMarkupId(true);
        Component[] componentArray5 = new Component[1];
        this.layerAndLabel = new WebMarkupContainer("layerAndLabel");
        componentArray5[0] = this.layerAndLabel;
        this.layerContainer.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.layerChoice = new DropDownChoice("layer", this.getLayerNames(rule.getRoot()));
        componentArray6[0] = this.layerChoice;
        this.layerAndLabel.add(componentArray6);
        this.layerAndLabel.setVisible(!rule.isGlobalGroupRule());
        this.layerChoice.setRequired(true);
        this.layerChoice.setOutputMarkupId(true);
        Component[] componentArray7 = new Component[1];
        this.accessModeChoice = new DropDownChoice("accessMode", MODES, (IChoiceRenderer)new AccessModeRenderer());
        componentArray7[0] = this.accessModeChoice;
        form.add(componentArray7);
        this.accessModeChoice.setRequired(true);
        Component[] componentArray8 = new Component[1];
        this.rolesFormComponent = new RuleRolesFormComponent("roles", (IModel<Collection<String>>)new PropertyModel((Object)rule, "roles")).setHasAnyRole(rule.getRoles().contains(GeoServerRole.ANY_ROLE.getAuthority()));
        componentArray8[0] = this.rolesFormComponent;
        form.add(componentArray8);
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                DataAccessRule rule = (DataAccessRule)this.getForm().getModelObject();
                if (AbstractDataAccessRulePage.this.rolesFormComponent.isHasAnyRole()) {
                    rule.getRoles().clear();
                    rule.getRoles().add(GeoServerRole.ANY_ROLE.getAuthority());
                }
                if (((Boolean)AbstractDataAccessRulePage.this.globalGroupRule.getModelObject()).booleanValue()) {
                    rule.setLayer(null);
                }
                AbstractDataAccessRulePage.this.onFormSubmit(rule);
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", DataSecurityPage.class)});
    }

    protected abstract void onFormSubmit(DataAccessRule var1);

    ArrayList<String> getLayerNames(String rootName) {
        ArrayList<String> result = new ArrayList<String>();
        if (!rootName.equals("*")) {
            Filter wsResources = Predicates.equal((String)"store.workspace.name", (Object)rootName);
            try (CloseableIterator it = this.getCatalog().list(ResourceInfo.class, wsResources);){
                while (it.hasNext()) {
                    result.add(((ResourceInfo)it.next()).getName());
                }
            }
            this.getCatalog().getLayerGroupsByWorkspace(rootName).stream().map(lg -> lg.getName()).forEach(name -> {
                if (!result.contains(name)) {
                    result.add((String)name);
                }
            });
            Collections.sort(result);
        }
        result.add(0, "*");
        return result;
    }

    protected void updateModels() {
        this.rootChoice.updateModel();
        this.layerChoice.updateModel();
        this.accessModeChoice.updateModel();
        this.rolesFormComponent.updateModel();
    }

    class EmptyRolesValidator
    extends AbstractFormValidator {
        EmptyRolesValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{AbstractDataAccessRulePage.this.rootChoice, AbstractDataAccessRulePage.this.layerChoice, AbstractDataAccessRulePage.this.accessModeChoice, AbstractDataAccessRulePage.this.rolesFormComponent};
        }

        public void validate(Form<?> form) {
            if (!form.findSubmitter().getInputName().equals("save")) {
                return;
            }
            AbstractDataAccessRulePage.this.updateModels();
            String roleInputString = AbstractDataAccessRulePage.this.rolesFormComponent.getPalette().getRecorderComponent().getInput();
            if ((roleInputString == null || roleInputString.trim().isEmpty()) && !AbstractDataAccessRulePage.this.rolesFormComponent.isHasAnyRole()) {
                form.error((Serializable)((Object)new ParamResourceModel("emptyRoles", (Component)AbstractDataAccessRulePage.this.getPage(), new Object[0]).getString()));
            }
        }
    }

    class AccessModeRenderer
    extends ChoiceRenderer<AccessMode> {
        AccessModeRenderer() {
        }

        public Object getDisplayValue(AccessMode object) {
            return new ParamResourceModel(object.name(), (Component)AbstractDataAccessRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(AccessMode object, int index) {
            return object.name();
        }
    }

    public class RootsModel
    extends LoadableDetachableModel<List<String>> {
        protected List<String> load() {
            if (((Boolean)AbstractDataAccessRulePage.this.globalGroupRule.getModelObject()).booleanValue()) {
                return this.getGlobalLayerGroupNames();
            }
            return this.getWorkspaceNames();
        }

        List<String> getGlobalLayerGroupNames() {
            Stream<String> names = AbstractDataAccessRulePage.this.getCatalog().getLayerGroupsByWorkspace(CatalogFacade.NO_WORKSPACE).stream().map(lg -> lg.getName()).sorted();
            return Stream.concat(Stream.of("*"), names).collect(Collectors.toList());
        }

        List<String> getWorkspaceNames() {
            Stream<String> names = AbstractDataAccessRulePage.this.getCatalog().getWorkspaces().stream().map(ws -> ws.getName()).sorted();
            return Stream.concat(Stream.of("*"), names).collect(Collectors.toList());
        }
    }

    public class RootLabelModel
    extends LoadableDetachableModel<String> {
        protected String load() {
            if (((Boolean)AbstractDataAccessRulePage.this.globalGroupRule.getModelObject()).booleanValue()) {
                return new ParamResourceModel("globalGroup", (Component)AbstractDataAccessRulePage.this, new Object[0]).getString();
            }
            return new ParamResourceModel("workspace", (Component)AbstractDataAccessRulePage.this, new Object[0]).getString();
        }
    }
}

