/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.web.auth.PreAuthenticatedUserNameFilterPanel;
import org.geoserver.security.web.auth.RoleSourceChoiceRenderer;

public abstract class J2eeBaseAuthFilterPanel<T extends J2eeAuthenticationBaseFilterConfig>
extends PreAuthenticatedUserNameFilterPanel<T> {
    private static final long serialVersionUID = 1L;

    public J2eeBaseAuthFilterPanel(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected void addRoleSourceDropDown(WebMarkupContainer container, RoleSource rs) {
        if (J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE.equals(rs)) {
            container.addOrReplace(new Component[]{new PreAuthenticatedUserNameFilterPanel.RoleServicePanel("panel")});
        } else {
            super.addRoleSourceDropDown(container, rs);
        }
    }

    @Override
    protected Panel getRoleSourcePanel(RoleSource model) {
        if (J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE.equals(model)) {
            return new PreAuthenticatedUserNameFilterPanel.RoleServicePanel("panel");
        }
        return super.getRoleSourcePanel(model);
    }

    @Override
    protected DropDownChoice<RoleSource> createRoleSourceDropDown() {
        return new DropDownChoice("roleSource", Arrays.asList(J2eeAuthenticationBaseFilterConfig.J2EERoleSource.values()), (IChoiceRenderer)new RoleSourceChoiceRenderer());
    }
}

