/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SequenceRuleNames implements Enumerator
{
    LINEAR(0, "Linear", "Linear"),
    BOUSTROPHEDONIC(1, "Boustrophedonic", "Boustrophedonic"),
    CANTOR_DIAGONAL(2, "CantorDiagonal", "Cantor-diagonal"),
    SPIRAL(3, "Spiral", "Spiral"),
    MORTON(4, "Morton", "Morton"),
    HILBERT(5, "Hilbert", "Hilbert");

    public static final int LINEAR_VALUE = 0;
    public static final int BOUSTROPHEDONIC_VALUE = 1;
    public static final int CANTOR_DIAGONAL_VALUE = 2;
    public static final int SPIRAL_VALUE = 3;
    public static final int MORTON_VALUE = 4;
    public static final int HILBERT_VALUE = 5;
    private static final SequenceRuleNames[] VALUES_ARRAY;
    public static final List<SequenceRuleNames> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SequenceRuleNames get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SequenceRuleNames result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SequenceRuleNames getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SequenceRuleNames result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SequenceRuleNames get(int value) {
        switch (value) {
            case 0: {
                return LINEAR;
            }
            case 1: {
                return BOUSTROPHEDONIC;
            }
            case 2: {
                return CANTOR_DIAGONAL;
            }
            case 3: {
                return SPIRAL;
            }
            case 4: {
                return MORTON;
            }
            case 5: {
                return HILBERT;
            }
        }
        return null;
    }

    private SequenceRuleNames(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SequenceRuleNames[]{LINEAR, BOUSTROPHEDONIC, CANTOR_DIAGONAL, SPIRAL, MORTON, HILBERT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

