/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CurveInterpolationType implements Enumerator
{
    LINEAR(0, "linear", "linear"),
    GEODESIC(1, "geodesic", "geodesic"),
    CIRCULAR_ARC3_POINTS(2, "circularArc3Points", "circularArc3Points"),
    CIRCULAR_ARC2_POINT_WITH_BULGE(3, "circularArc2PointWithBulge", "circularArc2PointWithBulge"),
    CIRCULAR_ARC_CENTER_POINT_WITH_RADIUS(4, "circularArcCenterPointWithRadius", "circularArcCenterPointWithRadius"),
    ELLIPTICAL(5, "elliptical", "elliptical"),
    CLOTHOID(6, "clothoid", "clothoid"),
    CONIC(7, "conic", "conic"),
    POLYNOMIAL_SPLINE(8, "polynomialSpline", "polynomialSpline"),
    CUBIC_SPLINE(9, "cubicSpline", "cubicSpline"),
    RATIONAL_SPLINE(10, "rationalSpline", "rationalSpline");

    public static final int LINEAR_VALUE = 0;
    public static final int GEODESIC_VALUE = 1;
    public static final int CIRCULAR_ARC3_POINTS_VALUE = 2;
    public static final int CIRCULAR_ARC2_POINT_WITH_BULGE_VALUE = 3;
    public static final int CIRCULAR_ARC_CENTER_POINT_WITH_RADIUS_VALUE = 4;
    public static final int ELLIPTICAL_VALUE = 5;
    public static final int CLOTHOID_VALUE = 6;
    public static final int CONIC_VALUE = 7;
    public static final int POLYNOMIAL_SPLINE_VALUE = 8;
    public static final int CUBIC_SPLINE_VALUE = 9;
    public static final int RATIONAL_SPLINE_VALUE = 10;
    private static final CurveInterpolationType[] VALUES_ARRAY;
    public static final List<CurveInterpolationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CurveInterpolationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CurveInterpolationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CurveInterpolationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CurveInterpolationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CurveInterpolationType get(int value) {
        switch (value) {
            case 0: {
                return LINEAR;
            }
            case 1: {
                return GEODESIC;
            }
            case 2: {
                return CIRCULAR_ARC3_POINTS;
            }
            case 3: {
                return CIRCULAR_ARC2_POINT_WITH_BULGE;
            }
            case 4: {
                return CIRCULAR_ARC_CENTER_POINT_WITH_RADIUS;
            }
            case 5: {
                return ELLIPTICAL;
            }
            case 6: {
                return CLOTHOID;
            }
            case 7: {
                return CONIC;
            }
            case 8: {
                return POLYNOMIAL_SPLINE;
            }
            case 9: {
                return CUBIC_SPLINE;
            }
            case 10: {
                return RATIONAL_SPLINE;
            }
        }
        return null;
    }

    private CurveInterpolationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CurveInterpolationType[]{LINEAR, GEODESIC, CIRCULAR_ARC3_POINTS, CIRCULAR_ARC2_POINT_WITH_BULGE, CIRCULAR_ARC_CENTER_POINT_WITH_RADIUS, ELLIPTICAL, CLOTHOID, CONIC, POLYNOMIAL_SPLINE, CUBIC_SPLINE, RATIONAL_SPLINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

