/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ProjectionPolicy;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.OperationNotFoundException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataUtilities;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.decorate.AbstractDecorator;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GeoServerFeatureStore;
import org.vfny.geoserver.global.QueryCapabilitiesDecorator;

public class GeoServerFeatureSource
extends AbstractDecorator<SimpleFeatureSource>
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    protected SimpleFeatureSource source;
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType schema;
    protected Filter definitionQuery = Filter.INCLUDE;
    protected CoordinateReferenceSystem declaredCRS;
    protected ProjectionPolicy srsHandling;
    protected MetadataMap metadata;
    protected Double linearizationTolerance;

    GeoServerFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> source, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling, Double linearizationTolerance, MetadataMap metadata) {
        this(source, new Settings(schema, definitionQuery, declaredCRS, srsHandling, linearizationTolerance, metadata));
    }

    GeoServerFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> source, Settings settings) {
        super((Object)DataUtilities.simple(source));
        this.source = DataUtilities.simple(source);
        this.schema = settings.schema;
        this.definitionQuery = settings.definitionQuery;
        this.declaredCRS = settings.declaredCRS;
        this.srsHandling = ProjectionPolicy.get(settings.srsHandling);
        this.linearizationTolerance = settings.linearizationTolerance;
        this.metadata = settings.metadata;
        if (this.definitionQuery == null) {
            this.definitionQuery = Filter.INCLUDE;
        }
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public static GeoServerFeatureSource create(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, Settings settings) {
        if (featureSource instanceof FeatureLocking) {
            return new GeoServerFeatureLocking((FeatureLocking<SimpleFeatureType, SimpleFeature>)((FeatureLocking)featureSource), settings);
        }
        if (featureSource instanceof FeatureStore) {
            return new GeoServerFeatureStore((FeatureStore<SimpleFeatureType, SimpleFeature>)((FeatureStore)featureSource), settings);
        }
        return new GeoServerFeatureSource(featureSource, settings);
    }

    protected Query makeDefinitionQuery(Query query, SimpleFeatureType schema) throws IOException {
        if (this.definitionQuery == null && this.linearizationTolerance == null) {
            return query;
        }
        try {
            String[] propNames = this.extractAllowedAttributes(query, schema);
            Filter filter = query.getFilter();
            filter = this.makeDefinitionFilter(filter);
            Query defQuery = new Query(query);
            defQuery.setFilter(filter);
            defQuery.setPropertyNames(propNames);
            defQuery.setCoordinateSystem(query.getCoordinateSystem());
            if (query.getSortBy() != null) {
                defQuery.setSortBy(query.getSortBy());
            }
            if (this.linearizationTolerance != null) {
                defQuery.getHints().put((Object)Hints.LINEARIZATION_TOLERANCE, (Object)this.linearizationTolerance);
            }
            return defQuery;
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] extractAllowedAttributes(Query query, SimpleFeatureType schema) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            ArrayList<String> props = new ArrayList<String>();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor att = schema.getDescriptor(i);
                if (Feature.class.isAssignableFrom(att.getType().getBinding()) && !query.getJoins().isEmpty()) continue;
                props.add(att.getLocalName());
            }
            propNames = props.toArray(new String[props.size()]);
        } else {
            String[] queriedAtts = query.getPropertyNames();
            LinkedList<String> allowedAtts = new LinkedList<String>();
            for (String queriedAtt : queriedAtts) {
                if (schema.getDescriptor(queriedAtt) != null) {
                    allowedAtts.add(queriedAtt);
                    continue;
                }
                LOGGER.info("queried a not allowed property: " + queriedAtt + ". Ommitting it from query");
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        try {
            if (this.definitionQuery == Filter.INCLUDE) {
                return filter;
            }
            SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
            Filter simplifiedDefinitionQuery = (Filter)this.definitionQuery.accept((FilterVisitor)visitor, null);
            if (filter == Filter.INCLUDE) {
                newFilter = simplifiedDefinitionQuery;
            } else if (simplifiedDefinitionQuery != Filter.INCLUDE) {
                newFilter = ff.and(simplifiedDefinitionQuery, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the definition filter", (Throwable)ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return (DataStore)this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SortBy[] sortBy = query.getSortBy();
        Integer offset = null;
        Integer maxFeatures = null;
        if (sortBy != null && sortBy != SortBy.UNSORTED) {
            if (!this.source.getQueryCapabilities().supportsSorting(sortBy)) {
                query.setSortBy(null);
                offset = query.getStartIndex();
                maxFeatures = query.getMaxFeatures() == Integer.MAX_VALUE ? null : Integer.valueOf(query.getMaxFeatures());
                query.setStartIndex(null);
                query.setMaxFeatures(Integer.MAX_VALUE);
            } else {
                sortBy = null;
            }
        }
        if (query.getStartIndex() != null && !this.source.getQueryCapabilities().isOffsetSupported()) {
            offset = query.getStartIndex();
            maxFeatures = query.getMaxFeatures() == Integer.MAX_VALUE ? null : Integer.valueOf(query.getMaxFeatures());
            query.setStartIndex(null);
            query.setMaxFeatures(Integer.MAX_VALUE);
        }
        Query reprojected = this.reprojectFilter(query);
        Query newQuery = this.adaptQuery(reprojected, this.schema);
        for (Map.Entry<String, Serializable> e : this.metadata.entrySet()) {
            try {
                Hints.ConfigurationMetadataKey key = Hints.ConfigurationMetadataKey.get((String)e.getKey());
                newQuery.getHints().put((Object)key, (Object)e.getValue());
            }
            catch (IllegalArgumentException ignore) {
                LOGGER.fine("Hint " + e.getKey() + ": " + ignore);
            }
        }
        CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
        try {
            SimpleFeatureCollection fc = this.source.getFeatures(newQuery);
            if (sortBy != null && sortBy != SortBy.UNSORTED) {
                fc = new SortedSimpleFeatureCollection(fc, sortBy);
            }
            if (offset != null || maxFeatures != null) {
                fc = new MaxSimpleFeatureCollection(fc, offset == null ? 0L : (long)offset.intValue(), maxFeatures == null ? Integer.MAX_VALUE : (long)maxFeatures.intValue());
            }
            return this.applyProjectionPolicies(targetCRS, fc);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    private Query reprojectFilter(Query query) throws IOException {
        SimpleFeatureType nativeFeatureType = (SimpleFeatureType)this.source.getSchema();
        GeometryDescriptor geom = nativeFeatureType.getGeometryDescriptor();
        if (geom == null) {
            return query;
        }
        try {
            CoordinateReferenceSystem defaultCRS = null;
            CoordinateReferenceSystem nativeCRS = geom.getCoordinateReferenceSystem();
            if (this.srsHandling == ProjectionPolicy.NONE && this.metadata.get("OTHER_SRS") != null) {
                defaultCRS = this.source.getInfo().getCRS();
                query.setCoordinateSystem(this.declaredCRS);
                return query;
            }
            if (this.srsHandling == ProjectionPolicy.FORCE_DECLARED) {
                defaultCRS = this.declaredCRS;
                nativeFeatureType = FeatureTypes.transform((SimpleFeatureType)nativeFeatureType, (CoordinateReferenceSystem)this.declaredCRS);
            } else {
                defaultCRS = this.srsHandling == ProjectionPolicy.REPROJECT_TO_DECLARED ? this.declaredCRS : nativeCRS;
            }
            DefaultCRSFilterVisitor defaultCRSVisitor = new DefaultCRSFilterVisitor(ff, defaultCRS);
            IncludeFilter filter = query.getFilter() != null ? query.getFilter() : Filter.INCLUDE;
            Filter defaultedFilter = (Filter)filter.accept((FilterVisitor)defaultCRSVisitor, null);
            ReprojectingFilterVisitor reprojectingVisitor = new ReprojectingFilterVisitor(ff, (FeatureType)nativeFeatureType);
            Filter reprojectedFilter = (Filter)defaultedFilter.accept((FilterVisitor)reprojectingVisitor, null);
            Query reprojectedQuery = new Query(query);
            reprojectedQuery.setFilter(reprojectedFilter);
            reprojectedQuery.setCoordinateSystem(this.declaredCRS);
            return reprojectedQuery;
        }
        catch (Exception e) {
            throw new DataSourceException("Had troubles handling filter reprojection...", (Throwable)e);
        }
    }

    protected SimpleFeatureCollection applyProjectionPolicies(CoordinateReferenceSystem targetCRS, SimpleFeatureCollection fc) throws IOException, SchemaException, TransformException, OperationNotFoundException, FactoryException {
        if (((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor() == null) {
            return fc;
        }
        CoordinateReferenceSystem nativeCRS = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
        if (nativeCRS == null) {
            if (this.declaredCRS != null) {
                fc = new ForceCoordinateSystemFeatureResults((FeatureCollection)fc, this.declaredCRS);
                nativeCRS = this.declaredCRS;
            }
        } else if (this.srsHandling == ProjectionPolicy.FORCE_DECLARED && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ForceCoordinateSystemFeatureResults((FeatureCollection)fc, this.declaredCRS);
            nativeCRS = this.declaredCRS;
        } else if (this.srsHandling == ProjectionPolicy.REPROJECT_TO_DECLARED && targetCRS == null && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ReprojectFeatureResults((FeatureCollection)fc, this.declaredCRS);
        }
        if (targetCRS != null) {
            if (nativeCRS == null) {
                fc = new ReprojectFeatureResults((FeatureCollection)fc, targetCRS);
            } else if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)targetCRS)) {
                fc = new ReprojectFeatureResults((FeatureCollection)fc, targetCRS);
            }
        }
        return fc;
    }

    protected Query adaptQuery(Query query, SimpleFeatureType schema) throws IOException {
        Query newQuery = this.makeDefinitionQuery(query, schema);
        if (newQuery.getCoordinateSystemReproject() != null) {
            newQuery.setCoordinateSystemReproject(null);
        }
        if (newQuery.getCoordinateSystem() != null && this.metadata.get("OTHER_SRS") == null) {
            newQuery.setCoordinateSystem(null);
        }
        return newQuery;
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.schema.getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public ReferencedEnvelope getBounds() throws IOException {
        if (this.definitionQuery == Filter.INCLUDE) {
            return this.source.getBounds();
        }
        Query query = new Query(this.getSchema().getTypeName(), this.definitionQuery);
        return this.source.getBounds(query);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return null;
        }
        return this.source.getBounds(query);
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.source.getSupportedHints();
    }

    public ResourceInfo getInfo() {
        return this.source.getInfo();
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilitiesDecorator(this.source.getQueryCapabilities()){

            @Override
            public boolean isOffsetSupported() {
                return true;
            }

            @Override
            public boolean supportsSorting(SortBy[] sortAttributes) {
                return true;
            }
        };
    }

    public static class Settings {
        protected SimpleFeatureType schema;
        protected Filter definitionQuery;
        protected CoordinateReferenceSystem declaredCRS;
        protected int srsHandling;
        protected Double linearizationTolerance;
        protected MetadataMap metadata;

        public Settings(SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling, Double linearizationTolerance, MetadataMap metadata) {
            this.schema = schema;
            this.definitionQuery = definitionQuery;
            this.declaredCRS = declaredCRS;
            this.srsHandling = srsHandling;
            this.linearizationTolerance = linearizationTolerance;
            this.metadata = metadata;
        }
    }
}

