/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.vfny.geoserver.global.GeoServerFeatureSource;
import org.vfny.geoserver.global.GeoServerFeatureStore;

public class GeoServerFeatureLocking
extends GeoServerFeatureStore
implements SimpleFeatureLocking {
    GeoServerFeatureLocking(FeatureLocking<SimpleFeatureType, SimpleFeature> locking, GeoServerFeatureSource.Settings settings) {
        super((FeatureStore<SimpleFeatureType, SimpleFeature>)locking, settings);
    }

    FeatureLocking<SimpleFeatureType, SimpleFeature> locking() {
        return (FeatureLocking)this.source;
    }

    public void setFeatureLock(FeatureLock lock) {
        if (!(this.source instanceof FeatureLocking)) {
            throw new UnsupportedOperationException("FeatureTypeConfig does not supports locking");
        }
        ((FeatureLocking)this.source).setFeatureLock(lock);
    }

    public int lockFeatures(Query query) throws IOException {
        if (this.source instanceof FeatureLocking) {
            return ((FeatureLocking)this.source).lockFeatures(query);
        }
        throw new DataSourceException("FeatureTypeConfig does not supports locking");
    }

    public int lockFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        return this.locking().lockFeatures(filter);
    }

    public int lockFeatures() throws IOException {
        return this.locking().lockFeatures();
    }

    public void unLockFeatures() throws IOException {
        this.locking().lockFeatures();
    }

    public void unLockFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.locking().unLockFeatures(filter);
    }

    public void unLockFeatures(Query query) throws IOException {
        query = this.makeDefinitionQuery(query, this.schema);
        this.locking().lockFeatures(query);
    }
}

