/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.geotools.util.URLs;

public class GeoserverCustomWKTFactory
extends FactoryUsingWKT {
    public static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "user.projections.file";

    protected URL getDefinitionsURL() {
        File proj_file;
        Resource custom_proj;
        GeoServerResourceLoader loader;
        String cust_proj_file = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        if (cust_proj_file == null && (loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)) != null && (custom_proj = loader.get("user_projections/epsg.properties")).getType() == Resource.Type.RESOURCE) {
            cust_proj_file = custom_proj.file().getAbsolutePath();
        }
        if (cust_proj_file != null && (proj_file = new File(cust_proj_file)).exists()) {
            URL url = URLs.fileToUrl((File)proj_file);
            if (url != null) {
                return url;
            }
            LOGGER.log(Level.SEVERE, "Had troubles converting file name to URL");
        }
        cust_proj_file = "user_epsg.properties";
        return GeoserverCustomWKTFactory.class.getResource(cust_proj_file);
    }
}

