/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;

public class DimensionWarning {
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    String layerName;
    String dimensionName;
    Object value;
    String unit;
    WarningType warningType;

    public static DimensionWarning nearest(ResourceInfo r, String dimensionName, Object value) {
        return new DimensionWarning(r, dimensionName, value, WarningType.Nearest);
    }

    public static DimensionWarning defaultValue(ResourceInfo r, String dimensionName, Object value) {
        return new DimensionWarning(r, dimensionName, value, WarningType.Default);
    }

    public static DimensionWarning notFound(ResourceInfo r, String dimensionName) {
        return new DimensionWarning(r, dimensionName, null, WarningType.FailedNearest);
    }

    protected DimensionWarning(ResourceInfo resource, String dimensionName, Object value, WarningType warningType) {
        this.layerName = resource.prefixedName();
        this.dimensionName = dimensionName;
        this.value = value;
        DimensionInfo di = resource.getMetadata().get(this.getKey(dimensionName), DimensionInfo.class);
        this.unit = di.getUnits();
        this.warningType = warningType;
    }

    protected DimensionWarning(DimensionWarning other) {
        this.layerName = other.layerName;
        this.dimensionName = other.dimensionName;
        this.value = other.value;
        this.unit = other.unit;
        this.warningType = other.warningType;
    }

    private String getKey(String dimensionName) {
        if ("time".equals(dimensionName) || "elevation".equals(dimensionName)) {
            return dimensionName;
        }
        return "custom_dimension_" + dimensionName;
    }

    public String getHeader() {
        if (this.warningType == WarningType.FailedNearest) {
            return "99 No nearest value found on " + this.layerName + ": " + this.dimensionName;
        }
        String type = this.warningType == WarningType.Nearest ? "Nearest value" : "Default value";
        String unitSpec = this.unit == null ? "" : this.unit;
        String valueSpec = this.formatValue(this.value);
        return "99 " + type + " used: " + this.dimensionName + "=" + valueSpec + " " + unitSpec + " (" + this.layerName + ")";
    }

    private String formatValue(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            sdf.setTimeZone(UTC_TZ);
            return sdf.format(value);
        }
        if (value == null) {
            return "-";
        }
        return value.toString();
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionWarning that = (DimensionWarning)o;
        return Objects.equals(this.layerName, that.layerName) && Objects.equals(this.dimensionName, that.dimensionName) && Objects.equals(this.value, that.value) && Objects.equals(this.unit, that.unit) && this.warningType == that.warningType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.layerName, this.dimensionName, this.value, this.unit, this.warningType});
    }

    public static enum WarningType {
        Default,
        Nearest,
        FailedNearest;

    }
}

