/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.util.logging.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class AllowListEntityResolver
implements EntityResolver2,
Serializable {
    public static String UNRESTRICTED = "*";
    public static String OGC1 = "schemas.opengis.net";
    public static String OGC2 = "www.opengis.net";
    public static String OGC = OGC1 + "|" + OGC2;
    public static String INSPIRE = "inspire.ec.europa.eu/schemas";
    public static String W3C = "www.w3.org";
    private static final String ERROR_MESSAGE_BASE = "Entity resolution disallowed for ";
    protected static final Logger LOGGER = Logging.getLogger(AllowListEntityResolver.class);
    private static final Pattern INTERNAL_URIS = Pattern.compile("(?i)(jar:file|vfs)[^?#;]*\\.xsd");
    private final Pattern ALLOWED_URIS;
    private final String baseURL;
    private final GeoServer geoServer;

    public AllowListEntityResolver(GeoServer geoServer) {
        this(geoServer, null);
    }

    public AllowListEntityResolver(GeoServer geoServer, String baseURL) {
        this.geoServer = geoServer;
        this.baseURL = baseURL;
        if (EntityResolverProvider.ALLOW_LIST == null || EntityResolverProvider.ALLOW_LIST.isEmpty()) {
            this.ALLOWED_URIS = Pattern.compile("(?i)(http|https)://(" + Pattern.quote(W3C) + "|" + Pattern.quote(OGC1) + "|" + Pattern.quote(OGC2) + "|" + Pattern.quote(INSPIRE) + ")/[^?#;]*\\.xsd");
        } else {
            StringBuilder pattern = new StringBuilder("(?i)(http|https)://(");
            boolean first = true;
            for (String allow : EntityResolverProvider.ALLOW_LIST) {
                if (first) {
                    first = false;
                } else {
                    pattern.append('|');
                }
                pattern.append(Pattern.quote(allow));
            }
            pattern.append(")/[^?#;]*\\.xsd");
            String regex = pattern.toString();
            LOGGER.fine("ENTITY_RESOLUTION_ALLOWLIST processed:" + regex);
            this.ALLOWED_URIS = Pattern.compile(regex);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return this.resolveEntity(name, null, baseURI, null);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("resolveEntity request: name=%s, publicId=%s, baseURI=%s, systemId=%s", name, publicId, baseURI, systemId));
        }
        try {
            Object uri;
            if (systemId == null) {
                if (name != null) {
                    LOGGER.finest("resolveEntity name: " + name);
                    return null;
                }
                throw new SAXException("External entity systemId not provided");
            }
            if (URI.create(systemId).isAbsolute()) {
                uri = systemId;
            } else {
                if (baseURI == null) {
                    throw new SAXException(ERROR_MESSAGE_BASE + systemId);
                }
                uri = (baseURI.endsWith(".xsd") || baseURI.endsWith(".XSD")) && baseURI.lastIndexOf(47) != -1 ? baseURI.substring(0, baseURI.lastIndexOf(47)) + "/" + systemId : baseURI + "/" + systemId;
            }
            if (INTERNAL_URIS.matcher((CharSequence)uri).matches()) {
                LOGGER.finest("resolveEntity internal: " + (String)uri);
                return null;
            }
            if (this.ALLOWED_URIS.matcher((CharSequence)uri).matches()) {
                LOGGER.finest("resolveEntity allowed: " + (String)uri);
                return null;
            }
            String uri_lowercase = ((String)uri).toLowerCase();
            if (this.geoServer != null) {
                String PROXY_BASE = this.geoServer.getSettings().getProxyBaseUrl();
                if (PROXY_BASE != null && uri_lowercase.startsWith(PROXY_BASE.toLowerCase())) {
                    LOGGER.finest("resolveEntity proxy base: " + (String)uri);
                    return null;
                }
                if (this.isDataDirectorySchema(systemId, this.geoServer)) {
                    LOGGER.finest("resolveEntity data directory: " + (String)uri);
                    return null;
                }
            }
            if (this.baseURL != null && uri_lowercase.startsWith(this.baseURL.toLowerCase())) {
                LOGGER.finest("resolveEntity proxy base: " + (String)uri);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SAXException(ERROR_MESSAGE_BASE + systemId);
    }

    private boolean isDataDirectorySchema(String systemId, GeoServer geoServer) throws IOException {
        String canonicalSystemId;
        GeoServerResourceLoader resourceLoader = geoServer.getCatalog().getResourceLoader();
        String path = resourceLoader.get("workspaces").dir().getCanonicalPath();
        if (systemId.startsWith("file:")) {
            systemId = systemId.substring(5);
        }
        return (canonicalSystemId = new File(systemId).getCanonicalPath()).startsWith(path) && canonicalSystemId.endsWith(".xsd");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AllowListEntityResolver:( ");
        builder.append(this.baseURL);
        builder.append(" ");
        builder.append(this.ALLOWED_URIS);
        builder.append(")");
        return builder.toString();
    }
}

