/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.core.TemplateClassResolver;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAccessPolicy;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Execute;
import freemarker.template.utility.ObjectConstructor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.geoserver.template.GeoServerMemberAccessPolicy;

public class TemplateUtils {
    public static final Version FM_VERSION = Configuration.VERSION_2_3_0;
    private static final Collection<String> ILLEGAL_FREEMARKER_CLASSES = Arrays.asList(ObjectConstructor.class.getName(), Execute.class.getName(), "freemarker.template.utility.JythonRuntime");
    private static final Collection<String> LEGAL_FREEMARKER_CLASSES = Arrays.asList(new String[0]);

    public static Configuration getSafeConfiguration() {
        return TemplateUtils.getSafeConfiguration(null, null, null);
    }

    public static Configuration getSafeConfiguration(BeansWrapper wrapper, MemberAccessPolicy policy, Integer exposureLevel) {
        Configuration templateConfig = new Configuration(FM_VERSION);
        templateConfig.setDefaultEncoding(StandardCharsets.UTF_8.name());
        templateConfig.setNewBuiltinClassResolver((name, env, template) -> {
            if (ILLEGAL_FREEMARKER_CLASSES.stream().anyMatch(name::equals)) {
                throw new TemplateException(String.format("Class %s is not allowed in Freemarker templates", name), env);
            }
            if (LEGAL_FREEMARKER_CLASSES.stream().anyMatch(name::equals)) {
                try {
                    ClassUtil.forName((String)name);
                }
                catch (ClassNotFoundException e) {
                    throw new TemplateException((Exception)e, env);
                }
            }
            return TemplateClassResolver.SAFER_RESOLVER.resolve(name, env, template);
        });
        templateConfig.setObjectWrapper((ObjectWrapper)TemplateUtils.getSafeWrapper(wrapper, policy, exposureLevel));
        return templateConfig;
    }

    public static BeansWrapper getSafeWrapper(BeansWrapper wrapper, MemberAccessPolicy policy, Integer exposureLevel) {
        int level;
        wrapper = wrapper != null ? wrapper : new DefaultObjectWrapper(FM_VERSION);
        int n = level = exposureLevel != null ? exposureLevel : 1;
        wrapper.setMemberAccessPolicy((MemberAccessPolicy)(policy != null ? policy : (level <= 1 ? GeoServerMemberAccessPolicy.DEFAULT_ACCESS : GeoServerMemberAccessPolicy.LIMIT_ACCESS)));
        wrapper.setExposureLevel(level);
        return wrapper;
    }
}

