/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.template.FeatureWrapper;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;

public class DirectTemplateFeatureCollectionFactory
implements FeatureWrapper.TemplateFeatureCollectionFactory<TemplateFeatureCollection> {
    static Logger LOGGER = Logging.getLogger(DirectTemplateFeatureCollectionFactory.class);
    static ThreadLocal<List<TemplateFeatureIterator>> ITERATORS = new ThreadLocal();

    public void purge() {
        List<TemplateFeatureIterator> its = ITERATORS.get();
        if (its != null) {
            for (TemplateFeatureIterator it : its) {
                try {
                    it.close();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Error closing iterator", t);
                }
            }
            its.clear();
            ITERATORS.remove();
        }
    }

    @Override
    public TemplateCollectionModel createTemplateFeatureCollection(FeatureCollection collection, BeansWrapper wrapper) {
        return new TemplateFeatureCollection(collection, wrapper);
    }

    protected class TemplateFeatureIterator
    implements TemplateModelIterator {
        protected BeansWrapper wrapper;
        protected FeatureIterator iterator;

        public TemplateFeatureIterator(FeatureIterator iterator, BeansWrapper wrapper) {
            this.iterator = iterator;
            this.wrapper = wrapper;
        }

        public TemplateModel next() throws TemplateModelException {
            return this.wrapper.wrap((Object)this.iterator.next());
        }

        public boolean hasNext() throws TemplateModelException {
            return this.iterator.hasNext();
        }

        public void close() {
            this.iterator.close();
        }
    }

    protected class TemplateFeatureCollection
    implements TemplateCollectionModel,
    TemplateSequenceModel {
        protected BeansWrapper wrapper;
        protected FeatureCollection collection;
        protected TemplateFeatureIterator indexIterator = null;
        protected int currentIndex = -1;
        protected TemplateModel currentItem = null;

        public TemplateFeatureCollection(FeatureCollection collection, BeansWrapper wrapper) {
            this.collection = collection;
            this.wrapper = wrapper;
        }

        public TemplateModelIterator iterator() throws TemplateModelException {
            TemplateFeatureIterator it = new TemplateFeatureIterator(this.collection.features(), this.wrapper);
            List<TemplateFeatureIterator> open = ITERATORS.get();
            if (open == null) {
                open = new LinkedList<TemplateFeatureIterator>();
                ITERATORS.set(open);
            }
            open.add(it);
            return it;
        }

        public TemplateModel get(int index) throws TemplateModelException {
            if (this.currentIndex > index) {
                if (this.indexIterator != null) {
                    ITERATORS.get().remove(this.indexIterator);
                    try {
                        this.indexIterator.close();
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, "Error closing iterator", t);
                    }
                    this.indexIterator = null;
                }
                this.currentIndex = -1;
                this.currentItem = null;
            }
            if (this.indexIterator == null) {
                this.indexIterator = (TemplateFeatureIterator)this.iterator();
            }
            while (this.currentIndex < index && this.indexIterator.hasNext()) {
                this.currentItem = this.indexIterator.next();
                ++this.currentIndex;
            }
            return index == this.currentIndex ? this.currentItem : null;
        }

        public int size() throws TemplateModelException {
            return this.collection.size();
        }
    }
}

