/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.security.xml.XMLSecurityConfigException;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;

public class XMLSecurityConfigValidator
extends SecurityConfigValidator {
    public XMLSecurityConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    @Override
    public void validate(SecurityRoleServiceConfig config) throws SecurityConfigException {
        super.validate(config);
        XMLRoleServiceConfig xmlConfig = (XMLRoleServiceConfig)config;
        this.validateCheckIntervall(xmlConfig.getCheckInterval());
        this.validateFileName(xmlConfig.getFileName());
    }

    @Override
    public void validate(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        super.validate(config);
        XMLUserGroupServiceConfig xmlConfig = (XMLUserGroupServiceConfig)config;
        this.validateCheckIntervall(xmlConfig.getCheckInterval());
        this.validateFileName(xmlConfig.getFileName());
    }

    protected void validateFileName(String fileName) throws SecurityConfigException {
        if (!this.isNotEmpty(fileName)) {
            throw this.createSecurityException("FILENAME_REQUIRED", new Object[0]);
        }
    }

    protected void validateCheckIntervall(long msecs) throws SecurityConfigException {
        if (msecs != 0L && msecs < 1000L) {
            throw this.createSecurityException("CHECK_INTERVAL_INVALID", new Object[0]);
        }
    }

    @Override
    public void validateRemoveRoleService(SecurityRoleServiceConfig config) throws SecurityConfigException {
        super.validateRemoveRoleService(config);
        XMLRoleServiceConfig xmlConfig = (XMLRoleServiceConfig)config;
        File file = new File(xmlConfig.getFileName());
        try {
            if (file.isAbsolute() && !file.getCanonicalPath().startsWith(this.manager.role().get(config.getName()).dir().getCanonicalPath() + File.separator)) {
                return;
            }
            if (this.manager.loadRoleService(config.getName()).getRoleCount() > 0) {
                throw this.createSecurityException("ROLE_SERVICE_NOT_EMPTY", config.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public void validateRemoveUserGroupService(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        XMLUserGroupServiceConfig xmlConfig = (XMLUserGroupServiceConfig)config;
        File file = new File(xmlConfig.getFileName());
        try {
            if (file.isAbsolute() && !file.getCanonicalPath().startsWith(this.manager.userGroup().get(config.getName()).file().getCanonicalPath() + File.separator)) {
                return;
            }
            GeoServerUserGroupService service = this.manager.loadUserGroupService(config.getName());
            if (service.getGroupCount() > 0 || service.getUserCount() > 0) {
                throw this.createSecurityException("USERGROUP_SERVICE_NOT_EMPTY", config.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        super.validateRemoveUserGroupService(config);
    }

    @Override
    public void validateAddRoleService(SecurityRoleServiceConfig config) throws SecurityConfigException {
        super.validateAddRoleService(config);
        XMLRoleServiceConfig xmlConfig = (XMLRoleServiceConfig)config;
        File file = new File(xmlConfig.getFileName());
        if (!this.checkFile(file)) {
            throw this.createSecurityException("FILE_CREATE_FAILED", file.getPath());
        }
    }

    @Override
    public void validateAddUserGroupService(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        super.validateAddUserGroupService(config);
        XMLUserGroupServiceConfig xmlConfig = (XMLUserGroupServiceConfig)config;
        File file = new File(xmlConfig.getFileName());
        if (!this.checkFile(file)) {
            throw this.createSecurityException("FILE_CREATE_FAILED", file.getPath());
        }
    }

    @Override
    public void validateModifiedRoleService(SecurityRoleServiceConfig config, SecurityRoleServiceConfig oldConfig) throws SecurityConfigException {
        super.validateModifiedRoleService(config, oldConfig);
        XMLRoleServiceConfig old = (XMLRoleServiceConfig)oldConfig;
        XMLRoleServiceConfig modified = (XMLRoleServiceConfig)config;
        if (!old.getFileName().equals(modified.getFileName())) {
            throw this.createSecurityException("FILENAME_CHANGE_INVALID", old.getFileName(), modified.getFileName());
        }
    }

    @Override
    public void validateModifiedUserGroupService(SecurityUserGroupServiceConfig config, SecurityUserGroupServiceConfig oldConfig) throws SecurityConfigException {
        super.validateModifiedUserGroupService(config, oldConfig);
        XMLUserGroupServiceConfig old = (XMLUserGroupServiceConfig)oldConfig;
        XMLUserGroupServiceConfig modified = (XMLUserGroupServiceConfig)config;
        if (!old.getFileName().equals(modified.getFileName())) {
            throw this.createSecurityException("FILENAME_CHANGE_INVALID", old.getFileName(), modified.getFileName());
        }
    }

    @Override
    public void validate(SecurityAuthProviderConfig config) throws SecurityConfigException {
        if (!this.isNotEmpty(config.getUserGroupServiceName())) {
            throw this.createSecurityException("USERGROUP_SERVICE_REQUIRED", new Object[0]);
        }
        super.validate(config);
    }

    @Override
    protected SecurityConfigException createSecurityException(String errorid, Object ... args) {
        return new XMLSecurityConfigException(errorid, args);
    }
}

