/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.validation.RoleServiceValidationWrapper;

public class RoleStoreValidationWrapper
extends RoleServiceValidationWrapper
implements GeoServerRoleStore {
    public RoleStoreValidationWrapper(GeoServerRoleStore store, boolean checkAgainstRules, GeoServerUserGroupService ... services) {
        super((GeoServerRoleService)store, checkAgainstRules, services);
    }

    public RoleStoreValidationWrapper(GeoServerRoleStore store, GeoServerUserGroupService ... services) {
        super((GeoServerRoleService)store, services);
    }

    GeoServerRoleStore getStore() {
        return (GeoServerRoleStore)this.service;
    }

    @Override
    public void initializeFromService(GeoServerRoleService aService) throws IOException {
        this.getStore().initializeFromService(aService);
    }

    @Override
    public void clear() throws IOException {
        this.getStore().clear();
    }

    @Override
    public void addRole(GeoServerRole role) throws IOException {
        this.checkReservedNames(role.getAuthority());
        this.checkNotExistingRoleName(role.getAuthority());
        this.checkNotExistingInOtherServices(role.getAuthority());
        this.getStore().addRole(role);
    }

    @Override
    public void updateRole(GeoServerRole role) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        this.getStore().updateRole(role);
    }

    @Override
    public boolean removeRole(GeoServerRole role) throws IOException {
        this.checkRoleIsMapped(role);
        this.checkRoleIsUsed(role);
        return this.getStore().removeRole(role);
    }

    @Override
    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        this.checkValidGroupName(groupname);
        this.getStore().associateRoleToGroup(role, groupname);
    }

    @Override
    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        this.checkValidGroupName(groupname);
        this.getStore().disAssociateRoleFromGroup(role, groupname);
    }

    @Override
    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        this.checkValidUserName(username);
        this.getStore().associateRoleToUser(role, username);
    }

    @Override
    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        this.checkValidUserName(username);
        this.getStore().disAssociateRoleFromUser(role, username);
    }

    @Override
    public void store() throws IOException {
        this.getStore().store();
    }

    @Override
    public boolean isModified() {
        return this.getStore().isModified();
    }

    @Override
    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        if (parentRole != null) {
            this.checkExistingRoleName(parentRole.getAuthority());
        }
        this.getStore().setParentRole(role, parentRole);
    }
}

