/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.Arrays;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.password.MasterPasswordChangeRequest;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.AbstractSecurityValidator;
import org.geoserver.security.validation.MasterPasswordChangeException;
import org.geoserver.security.validation.PasswordPolicyException;

public class MasterPasswordChangeValidator
extends AbstractSecurityValidator {
    public MasterPasswordChangeValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    protected void checkCurrentPassword(MasterPasswordChangeRequest request) throws MasterPasswordChangeException {
        if (!this.isNotEmpty(request.getCurrentPassword())) {
            throw this.createSecurityException("CURRENT_PASSWORD_REQUIRED", new Object[0]);
        }
        try {
            if (!this.manager.getKeyStoreProvider().isKeyStorePassword(request.getCurrentPassword())) {
                throw this.createSecurityException("CURRENT_PASSWORD_ERROR", new Object[0]);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void checkConfirmationPassword(MasterPasswordChangeRequest request) throws MasterPasswordChangeException {
        if (!this.isNotEmpty(request.getConfirmPassword())) {
            throw this.createSecurityException("CONFIRMATION_PASSWORD_REQUIRED", new Object[0]);
        }
    }

    protected void checkNewPassword(MasterPasswordChangeRequest request) throws MasterPasswordChangeException {
        if (!this.isNotEmpty(request.getNewPassword())) {
            throw this.createSecurityException("NEW_PASSWORD_REQUIRED", new Object[0]);
        }
    }

    protected void checkNewEqualsConfirmation(char[] newPassword, char[] confirmationPassword) throws MasterPasswordChangeException {
        if (!Arrays.equals(newPassword, confirmationPassword)) {
            throw this.createSecurityException("PASSWORD_AND_CONFIRMATION_NOT_EQUAL", new Object[0]);
        }
    }

    protected void checkNewEqualsCurrent(char[] newPassword, char[] currentPassword) throws MasterPasswordChangeException {
        if (Arrays.equals(newPassword, currentPassword)) {
            throw this.createSecurityException("NEW_EQUALS_CURRENT", new Object[0]);
        }
    }

    public void validateChangeRequest(MasterPasswordChangeRequest request) throws MasterPasswordChangeException, PasswordPolicyException {
        this.checkCurrentPassword(request);
        this.checkConfirmationPassword(request);
        this.checkNewPassword(request);
        this.checkNewEqualsConfirmation(request.getNewPassword(), request.getConfirmPassword());
        this.validatePasswordAgainstPolicy(request.getNewPassword());
        this.checkNewEqualsCurrent(request.getNewPassword(), request.getCurrentPassword());
    }

    protected MasterPasswordChangeException createSecurityException(String errorid, Object ... args) {
        return new MasterPasswordChangeException(errorid, args);
    }

    protected void validatePasswordAgainstPolicy(char[] password) throws PasswordPolicyException {
        PasswordValidator val = null;
        try {
            val = this.manager.loadPasswordValidator("master");
            val.validatePassword(password);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

