/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.CredentialsFromRequestHeaderFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.validation.CredentialsFromRequestHeaderFilterConfigException;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.validation.FilterConfigValidator;

public class CredentialsFromRequestHeaderFilterConfigValidator
extends FilterConfigValidator {
    public CredentialsFromRequestHeaderFilterConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    @Override
    public void validateFilterConfig(SecurityNamedServiceConfig config) throws FilterConfigException {
        if (config instanceof CredentialsFromRequestHeaderFilterConfig) {
            this.validateFilterConfig((CredentialsFromRequestHeaderFilterConfig)config);
        } else {
            super.validateFilterConfig(config);
        }
    }

    public void validateFilterConfig(CredentialsFromRequestHeaderFilterConfig config) throws FilterConfigException {
        if (config.getUserNameHeaderName() == null || "".equals(config.getUserNameHeaderName())) {
            throw new CredentialsFromRequestHeaderFilterConfigException("USERNAME_HEADER_REQUIRED", null);
        }
        if (config.getUserNameRegex() == null || "".equals(config.getUserNameRegex())) {
            throw new CredentialsFromRequestHeaderFilterConfigException("USERNAME_REGEX_REQUIRED", null);
        }
        if (config.getPasswordHeaderName() == null || "".equals(config.getPasswordHeaderName())) {
            throw new CredentialsFromRequestHeaderFilterConfigException("PASSWORD_HEADER_REQUIRED", null);
        }
        if (config.getPasswordRegex() == null || "".equals(config.getPasswordRegex())) {
            throw new CredentialsFromRequestHeaderFilterConfigException("PASSWORD_REGEX_REQUIRED", null);
        }
    }
}

