/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.File;
import java.io.IOException;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.validation.SecurityConfigException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSecurityValidator {
    protected GeoServerSecurityManager manager;

    public AbstractSecurityValidator(GeoServerSecurityManager securityManager) {
        this.manager = securityManager;
    }

    protected boolean isNotEmpty(String aString) {
        return aString != null && !aString.isEmpty();
    }

    protected boolean isNotEmpty(char[] aString) {
        return aString != null && aString.length > 0;
    }

    protected Object lookupBean(String name) throws NoSuchBeanDefinitionException {
        Object bean = GeoServerExtensions.bean((String)name, (ApplicationContext)this.manager.getApplicationContext());
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return bean;
    }

    public File getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            return null;
        }
        File tempDir = new File(tempPath);
        if (!tempDir.exists()) {
            return null;
        }
        if (!tempDir.isDirectory()) {
            return null;
        }
        if (!tempDir.canWrite()) {
            return null;
        }
        return tempDir;
    }

    protected boolean checkFile(File file) throws SecurityConfigException {
        File testFile = null;
        try {
            if (file.isAbsolute()) {
                testFile = file;
            } else {
                File tempDir = this.getTempDir();
                if (tempDir == null) {
                    return true;
                }
                testFile = new File(tempDir, file.getPath());
            }
            if (!testFile.exists()) {
                testFile.createNewFile();
                testFile.delete();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

