/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geotools.util.logging.Logging;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;

public class GeoServerMultiplexingPasswordEncoder
implements PasswordEncoder {
    static Logger LOG = Logging.getLogger(GeoServerMultiplexingPasswordEncoder.class);
    protected Set<GeoServerPasswordEncoder> encoders = new HashSet<GeoServerPasswordEncoder>();

    public GeoServerMultiplexingPasswordEncoder(GeoServerSecurityManager secMgr) {
        this(secMgr, null);
    }

    public GeoServerMultiplexingPasswordEncoder(GeoServerSecurityManager secMgr, GeoServerUserGroupService service) {
        for (GeoServerPasswordEncoder enc : secMgr.loadPasswordEncoders()) {
            if (!StringUtils.hasLength((String)enc.getPrefix())) continue;
            if (service != null) {
                try {
                    if (enc instanceof GeoServerPBEPasswordEncoder && !secMgr.getKeyStoreProvider().hasUserGroupKey(service.getName())) continue;
                    enc.initializeFor(service);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.encoders.add(enc);
        }
    }

    GeoServerPasswordEncoder lookupEncoderForEncodedPassword(String encPass) throws UnsupportedOperationException {
        for (GeoServerPasswordEncoder enc : this.encoders) {
            if (!enc.isResponsibleForEncoding(encPass)) continue;
            return enc;
        }
        throw new UnsupportedOperationException("No password decoder for: " + encPass);
    }

    public String encodePassword(String rawPass, Object salt) throws UnsupportedOperationException {
        for (GeoServerPasswordEncoder enc : this.encoders) {
            try {
                return enc.encodePassword(rawPass, salt);
            }
            catch (Exception e) {
                LOG.fine("Password encode failed with " + enc.getName());
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws UnsupportedOperationException {
        GeoServerPasswordEncoder enc = this.lookupEncoderForEncodedPassword(encPass);
        return enc.isPasswordValid(encPass, rawPass, salt);
    }

    public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) throws UnsupportedOperationException {
        GeoServerPasswordEncoder enc = this.lookupEncoderForEncodedPassword(encPass);
        return enc.isPasswordValid(encPass, rawPass, salt);
    }

    public String decode(String encPass) throws UnsupportedOperationException {
        GeoServerPasswordEncoder enc = this.lookupEncoderForEncodedPassword(encPass);
        return enc.decode(encPass);
    }

    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        GeoServerPasswordEncoder enc = this.lookupEncoderForEncodedPassword(encPass);
        return enc.decodeToCharArray(encPass);
    }

    public String encode(CharSequence rawPassword) {
        return this.encodePassword(rawPassword.toString(), null);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return this.isPasswordValid(encodedPassword, rawPassword.toString(), null);
    }
}

