/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.springframework.util.StringUtils;

public class UserGroupStoreHelper {
    public TreeMap<String, GeoServerUser> userMap = new TreeMap();
    public TreeMap<String, GeoServerUserGroup> groupMap = new TreeMap();
    public TreeMap<GeoServerUserGroup, SortedSet<GeoServerUser>> group_userMap = new TreeMap();
    public TreeMap<GeoServerUser, SortedSet<GeoServerUserGroup>> user_groupMap = new TreeMap();
    public TreeMap<String, SortedSet<GeoServerUser>> propertyMap = new TreeMap();
    protected SortedSet<GeoServerUser> emptyUsers = Collections.unmodifiableSortedSet(new TreeSet());
    protected SortedSet<GeoServerUserGroup> emptyGroups = Collections.unmodifiableSortedSet(new TreeSet());

    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.userMap.get(username);
    }

    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.groupMap.get(groupname);
    }

    public SortedSet<GeoServerUser> getUsers() throws IOException {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        users.addAll(this.userMap.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        groups.addAll(this.groupMap.values());
        return Collections.unmodifiableSortedSet(groups);
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        SortedSet<GeoServerUserGroup> groups = this.user_groupMap.get(user);
        if (groups == null) {
            return this.emptyGroups;
        }
        return Collections.unmodifiableSortedSet(groups);
    }

    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        SortedSet<GeoServerUser> users = this.group_userMap.get(group);
        if (users == null) {
            return this.emptyUsers;
        }
        return Collections.unmodifiableSortedSet(users);
    }

    public void clearMaps() {
        this.userMap.clear();
        this.groupMap.clear();
        this.user_groupMap.clear();
        this.group_userMap.clear();
        this.propertyMap.clear();
    }

    public int getUserCount() throws IOException {
        return this.userMap.size();
    }

    public int getGroupCount() throws IOException {
        return this.groupMap.size();
    }

    SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        SortedSet<GeoServerUser> users = this.propertyMap.get(propname);
        if (users == null) {
            return this.emptyUsers;
        }
        return Collections.unmodifiableSortedSet(users);
    }

    int getUserCountHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return 0;
        }
        SortedSet<GeoServerUser> users = this.propertyMap.get(propname);
        if (users == null) {
            return 0;
        }
        return users.size();
    }

    SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        SortedSet<GeoServerUser> users = this.getUsersHavingProperty(propname);
        TreeSet<GeoServerUser> result = new TreeSet<GeoServerUser>();
        result.addAll(this.userMap.values());
        result.removeAll(users);
        return Collections.unmodifiableSortedSet(result);
    }

    int getUserCountNotHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.userMap.size();
        }
        return this.userMap.size() - this.getUserCountHavingProperty(propname);
    }

    SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        if (!StringUtils.hasLength((String)propvalue)) {
            return this.emptyUsers;
        }
        TreeSet<GeoServerUser> result = new TreeSet<GeoServerUser>();
        for (GeoServerUser user : this.getUsersHavingProperty(propname)) {
            if (!propvalue.equals(user.getProperties().getProperty(propname))) continue;
            result.add(user);
        }
        return Collections.unmodifiableSortedSet(result);
    }

    int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        int count = 0;
        if (!StringUtils.hasLength((String)propname)) {
            return count;
        }
        if (!StringUtils.hasLength((String)propvalue)) {
            return count;
        }
        for (GeoServerUser user : this.getUsersHavingProperty(propname)) {
            if (!propvalue.equals(user.getProperties().getProperty(propname))) continue;
            ++count;
        }
        return count;
    }
}

