/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.geoserver.security.AccessMode;

public class DataAccessRule
implements Comparable<DataAccessRule>,
Serializable {
    public static final String ANY = "*";
    public static DataAccessRule READ_ALL = new DataAccessRule("*", "*", AccessMode.READ, new String[0]);
    public static DataAccessRule WRITE_ALL = new DataAccessRule("*", "*", AccessMode.WRITE, new String[0]);
    String root;
    String layer;
    AccessMode accessMode;
    Set<String> roles;
    boolean globalGroupRule;

    public DataAccessRule(String root, String layer, AccessMode accessMode, Set<String> roles) {
        this.root = root;
        this.layer = layer;
        this.globalGroupRule = layer == null;
        this.accessMode = accessMode;
        this.roles = roles == null ? new HashSet<String>() : new HashSet<String>(roles);
    }

    public DataAccessRule(String root, String layer, AccessMode accessMode, String ... roles) {
        this(root, layer, accessMode, (Set<String>)(roles == null ? null : new HashSet<String>(Arrays.asList(roles))));
    }

    public DataAccessRule(DataAccessRule other) {
        this.root = other.root;
        this.layer = other.layer;
        this.accessMode = other.accessMode;
        this.globalGroupRule = other.globalGroupRule;
        this.roles = new HashSet<String>(other.roles);
    }

    public DataAccessRule() {
        this(ANY, ANY, AccessMode.READ, new String[0]);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean isGlobalGroupRule() {
        return this.globalGroupRule;
    }

    public void setGlobalGroupRule(boolean globalGroupRule) {
        this.globalGroupRule = globalGroupRule;
    }

    public String getKey() {
        if (this.globalGroupRule) {
            return this.root + "." + this.accessMode.getAlias();
        }
        return this.root + "." + this.layer + "." + this.accessMode.getAlias();
    }

    public String getValue() {
        if (this.roles.isEmpty()) {
            return ANY;
        }
        StringBuffer sb = new StringBuffer();
        for (String role : this.roles) {
            sb.append(role);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public int compareTo(DataAccessRule other) {
        int compareRoot = this.compareCatalogItems(this.root, other.root);
        if (compareRoot != 0) {
            return compareRoot;
        }
        int compareLayer = this.compareCatalogItems(this.layer, other.layer);
        if (compareLayer != 0) {
            return compareLayer;
        }
        if (this.accessMode.equals((Object)other.accessMode)) {
            return 0;
        }
        return this.accessMode.equals((Object)AccessMode.READ) ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataAccessRule)) {
            return false;
        }
        return 0 == this.compareTo((DataAccessRule)obj);
    }

    public boolean equalsExact(DataAccessRule obj) {
        if (0 != this.compareTo(obj)) {
            return false;
        }
        return this.roles.equals(obj.roles);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.root).append((Object)this.layer).append((Object)this.accessMode.getAlias()).toHashCode();
    }

    public int compareCatalogItems(String item, String otherItem) {
        if (item == null) {
            return otherItem != null ? -1 : 0;
        }
        if (item.equals(otherItem) || ANY.equals(item) && otherItem == null || item == null && ANY.equals(otherItem)) {
            return 0;
        }
        if (ANY.equals(item)) {
            return -1;
        }
        if (ANY.equals(otherItem)) {
            return 1;
        }
        return item.compareTo(otherItem);
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

