/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.impl.GeoServerRole;
import org.geotools.util.logging.Logging;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GeoServerSecurityMetadataSource
implements SecurityMetadataSource {
    static final Map<RequestMatcher, Collection<ConfigAttribute>> requestMap;
    private Logger logger = Logging.getLogger(GeoServerSecurityMetadataSource.class);

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        requestMap.values().forEach(allAttributes::addAll);
        return allAttributes;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        HttpServletRequest request = (HttpServletRequest)object;
        int count = 0;
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : requestMap.entrySet()) {
            if (entry.getKey().matches(request)) {
                return entry.getValue();
            }
            if (!this.logger.isLoggable(Level.FINEST)) continue;
            String msg = LogMessage.format((String)"Did not match request to %s - %s (%d/%d)", (Object)entry.getKey(), entry.getValue(), (Object)(++count), (Object)requestMap.size()).toString();
            this.logger.finest(msg);
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return HttpServletRequest.class.isAssignableFrom(clazz);
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        map.put(new LoginPageRequestMatcher(), new ArrayList());
        map.put((LoginPageRequestMatcher)new AntPathRequestMatcher("/web/resources/**"), new ArrayList());
        AntPathRequestMatcher matcher = new AntPathRequestMatcher("/config/**");
        ArrayList<SecurityConfig> list2 = new ArrayList<SecurityConfig>();
        list2.add(new SecurityConfig(GeoServerRole.ADMIN_ROLE.getAuthority()));
        map.put((LoginPageRequestMatcher)matcher, list2);
        matcher = new AntPathRequestMatcher("/**");
        list2 = new ArrayList();
        list2.add(new SecurityConfig("IS_AUTHENTICATED_ANONYMOUSLY"));
        map.put((LoginPageRequestMatcher)matcher, list2);
        requestMap = Collections.unmodifiableMap(map);
    }

    static class LoginPageRequestMatcher
    implements RequestMatcher {
        RequestMatcher webChainMatcher1 = new AntPathRequestMatcher("/web");
        RequestMatcher webChainMatcher2 = new AntPathRequestMatcher("/web/");

        LoginPageRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            boolean isOnWebChain;
            boolean bl = isOnWebChain = this.webChainMatcher1.matches(request) || this.webChainMatcher2.matches(request);
            if (!isOnWebChain) {
                return false;
            }
            Map params = request.getParameterMap();
            if (params.size() != 2) {
                return false;
            }
            String[] pageClass = (String[])params.get("wicket:bookmarkablePage");
            if (pageClass == null || pageClass.length != 1) {
                return false;
            }
            if (!":org.geoserver.web.GeoServerLoginPage".equals(pageClass[0])) {
                return false;
            }
            String[] error = (String[])params.get("error");
            return error != null && error.length == 1;
        }
    }
}

